/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl;

import org.apache.log4j.Logger;
import org.gcube.vomanagement.vomsapi.CredentialsManager;
import org.gcube.vomanagement.vomsapi.ExtendedVOMSAdmin;
import org.gcube.vomanagement.vomsapi.impl.CredentialsRetrievalException;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfiguration;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.impl.VOMSAdminException;
import org.gcube.vomanagement.vomsapi.impl.VOMSAttributeAdder;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;

class CredentialsManagerImpl
extends VOMSAttributeAdder
implements CredentialsManager {
    private Logger logger = Logger.getLogger(this.getClass());

    CredentialsManagerImpl(VOMSAPIConfiguration configuration, ExtendedVOMSAdmin extendedVOMSAdmin) {
        super(configuration, extendedVOMSAdmin);
    }

    @Override
    public ExtendedGSSCredential getPlainCredentials(String userName) throws CredentialsRetrievalException {
        return this.getPlainCredentials(userName, "      ");
    }

    @Override
    public ExtendedGSSCredential getPlainCredentials(String userName, String password) throws CredentialsRetrievalException {
        MyProxy myproxy = new MyProxy(this.config.getProperty(VOMSAPIConfigurationProperty.MYPROXY_HOST), this.config.getMyProxyPort());
        ExtendedGSSCredential credentials = this.config.getCredentials();
        return this.getPlainCredentials(myproxy, credentials, userName, password);
    }

    @Override
    public ExtendedGSSCredential getAttributedCredentials(String userName, String groupName) throws CredentialsRetrievalException, VOMSAdminException {
        ExtendedGSSCredential credentials = this.getPlainCredentials(userName);
        return this.addVOMSRoles(credentials, groupName);
    }

    @Override
    public ExtendedGSSCredential getAttributedCredentials(String userName, String password, String groupName) throws CredentialsRetrievalException, VOMSAdminException {
        ExtendedGSSCredential credentials = this.getPlainCredentials(userName);
        return this.addVOMSRoles(credentials, groupName);
    }

    ExtendedGSSCredential getPlainCredentials(MyProxy myproxy, ExtendedGSSCredential credentials, String userName, String password) throws CredentialsRetrievalException {
        this.logger.debug((Object)("Retrieving credentials from MyProxy (" + myproxy.getHost() + ":" + myproxy.getPort() + " for username " + userName + " using " + CredentialsUtil.stringCredentials(credentials)));
        try {
            ExtendedGSSCredential retrievedCredentials = (ExtendedGSSCredential)myproxy.get((GSSCredential)credentials, userName, password, 86400);
            this.logger.info((Object)("Retrieved " + CredentialsUtil.stringCredentials(retrievedCredentials) + " for username " + userName));
            return retrievedCredentials;
        }
        catch (MyProxyException e) {
            String msg = "Cannot get credentials from MyProxy at " + myproxy.getHost() + ":" + myproxy.getPort() + " for userName " + userName + " using " + CredentialsUtil.stringCredentials(credentials);
            this.logger.error((Object)msg, (Throwable)e);
            throw new CredentialsRetrievalException(msg, e);
        }
    }
}

