/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.util;

import org.gcube.vomanagement.vomsapi.util.VOMSFQANInfo;

public class VOMSRole
implements VOMSFQANInfo {
    private String groupName;
    public String voName;
    private String roleName;

    public VOMSRole(String groupName, String voName, String roleName) {
        this.groupName = groupName;
        this.voName = voName;
        this.roleName = roleName;
    }

    public VOMSRole(String VOMSRole2) {
        if (VOMSRole2 == null) {
            throw new NullPointerException("VOMS role cannot be null.");
        }
        if (VOMSRole2.equals("")) {
            throw new IllegalArgumentException("VOMS role cannot be an empty string.");
        }
        String[] voName_groupRoleName = VOMSRole2.split(":");
        if (voName_groupRoleName.length != 2) {
            throw new IllegalArgumentException("This is not a valid VOMS role structure.");
        }
        this.voName = voName_groupRoleName[0];
        String group_role = voName_groupRoleName[1];
        String[] groupName_RoleName = group_role.split("/Role=");
        if (groupName_RoleName.length != 2) {
            throw new IllegalArgumentException("This is not a valid VOMS role structure.");
        }
        if (!groupName_RoleName[0].startsWith("/")) {
            throw new IllegalArgumentException("This is not a valid VOMS role structure.");
        }
        this.groupName = groupName_RoleName[0];
        this.roleName = groupName_RoleName[1];
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getString() {
        StringBuilder response = new StringBuilder(this.voName);
        response.append(":").append(this.groupName).append("/Role=").append(this.roleName);
        return response.toString();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public String getVoName() {
        return this.voName;
    }

    @Override
    public void setVoName(String voName) {
        this.voName = voName;
    }

    public void setCapability(String capability) {
    }

    public String getCapability() {
        return null;
    }

    @Override
    public String getFQAN() {
        StringBuilder response = new StringBuilder(this.groupName);
        response.append("/Role=").append(this.roleName);
        return response.toString();
    }
}

