/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.securitymanager;

import java.rmi.Remote;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis.client.Stub;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.configuration.GCUBEServiceSecurityConfigurationManager;
import org.gcube.vomanagement.vomsapi.securitymanager.task.VomsProxyConsumer;
import org.gcube.vomanagement.vomsapi.securitymanager.task.VomsProxyTask;
import org.gcube.vomanagement.vomsapi.securitymanager.task.bean.VOMSServerInformationBean;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;

public class VOMSServiceCredentialsSecurityManager
extends GCUBEServiceSecurityConfigurationManager
implements VomsProxyConsumer {
    public static final String VOMS_HOST = "VomsServer";
    public static final String VO_NAME = "VoName";
    public static final String VOMS_ADMIN_PORT = "vomsAdminPort";
    public static final String VOMS_SERVICE_DN = "vomsServiceDN";
    public static final String VOMS_SERVICE_PORT = "vomsServicePort";
    public static final String SERVICE_KEY = "ServiceKey";
    public static final String SERVICE_CERT = "ServiceCert";
    public static final String CREDENTIAL_PASSWORD = "ServiceKeyPwd";
    private ExtendedGSSCredential internalCredentials;
    private Timer credentialRenewalTimer;
    private GCUBELog logger = new GCUBELog((Object)this);

    public SecurityCredentials getCallerCredentials() throws Exception {
        this.logger.warn((Object)"No caller credential management supported in this security manager");
        return null;
    }

    public void initialise(GCUBEServiceContext ctxt) throws Exception {
        super.initialise(ctxt);
        ExtendedGSSCredential serviceCredential = this.initCredentials((String)ctxt.getProperty(SERVICE_CERT, new boolean[0]), (String)ctxt.getProperty(SERVICE_KEY, new boolean[0]), (String)ctxt.getProperty(CREDENTIAL_PASSWORD, new boolean[0]));
        VOMSServerInformationBean configurationBean = this.generateConfigurationBean(ctxt, serviceCredential);
        this.initialiseCredentialTask(ctxt.getService().getServiceName(), configurationBean, serviceCredential);
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.POLICYUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
        this.serviceCredentials = new GSSSecurityCredentials((GSSCredential)serviceCredential);
    }

    private ExtendedGSSCredential initCredentials(String serviceCert, String serviceKey, String pwd) throws Exception {
        ExtendedGSSCredential credentials = null;
        if (serviceCert != null && serviceKey != null) {
            this.logger.debug((Object)"Generating service credentials");
            credentials = CredentialsUtil.loadEndEntityCredentials((String)serviceCert, (String)serviceKey, (String)pwd);
            this.logger.debug((Object)"Service credentials generated");
        } else {
            this.logger.debug((Object)"Using default host credentials...");
            credentials = (ExtendedGSSCredential)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials();
        }
        return credentials;
    }

    public boolean needServiceCredentials() {
        return true;
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.logger.warn((Object)"The only credentials to be user are configured in the jndi");
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        this.logger.warn((Object)"The only credentials to be user are configured in the jndi");
    }

    public SecurityCredentials getCredentials() {
        return new GSSSecurityCredentials((GSSCredential)this.internalCredentials);
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.logger.debug((Object)("setting security parameters for service " + this.context.getService().getServiceName()));
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)this.internalCredentials);
            String authMethodString = null;
            if (this.authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                this.logger.debug((Object)"GSI Secure conversation");
                authMethodString = "org.globus.security.secConv.msg.type";
                this.logger.debug((Object)"Setting delegation...");
                this.logger.debug((Object)("delegation " + e));
                switch (d) {
                    case FULL: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                        break;
                    }
                    case LIMITED: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
                    }
                }
            } else {
                this.logger.debug((Object)"GSI Secure transport");
                authMethodString = "org.globus.security.transport.type";
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                }
            }
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }

    @Override
    public synchronized void setVomsProxyCredentials(ExtendedGSSCredential credential) {
        this.internalCredentials = credential;
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.CREDENTIALUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
    }

    private void initialiseCredentialTask(String serviceName, VOMSServerInformationBean configurationBean, ExtendedGSSCredential serviceCredentials) throws Exception {
        if (!this.isSecurityEnabled()) {
            this.logger.info((Object)("no credentials are needed for service " + this.context.getServiceClass() + ":" + this.context.getName()));
            this.setVomsProxyCredentials(null);
        } else {
            this.logger.info((Object)("subscribing for credentials for service " + this.context.getServiceClass() + ":" + this.context.getName()));
            VomsProxyTask renewalTask = new VomsProxyTask(serviceName, serviceCredentials, configurationBean, this);
            this.credentialRenewalTimer = new Timer(renewalTask.getName());
            this.credentialRenewalTimer.schedule((TimerTask)renewalTask, 0L, renewalTask.getTimerPeriod());
        }
    }

    private VOMSServerInformationBean generateConfigurationBean(GCUBEServiceContext ctx, ExtendedGSSCredential credential) throws Exception {
        if (credential == null) {
            throw new Exception("Credential null!");
        }
        String adminPort = (String)ctx.getProperty(VOMS_ADMIN_PORT, new boolean[0]);
        String host = (String)ctx.getProperty(VOMS_HOST, new boolean[0]);
        String voName = (String)ctx.getProperty(VO_NAME, new boolean[0]);
        this.logger.debug((Object)("Host " + host));
        this.logger.debug((Object)("Adnin Port " + adminPort));
        this.logger.debug((Object)("VO Name " + voName));
        if (host == null || adminPort == null || voName == null) {
            throw new Exception("Invalid configuration");
        }
        VOMSServerInformationBean configurationBean = new VOMSServerInformationBean();
        configurationBean.setVomsAdminCredentials(credential);
        configurationBean.setVomsAdminPort(adminPort);
        configurationBean.setVomsHost(host);
        configurationBean.setVoName(voName);
        String dn = (String)ctx.getProperty(VOMS_SERVICE_DN, new boolean[0]);
        Integer servicePort = (Integer)ctx.getProperty(VOMS_SERVICE_PORT, new boolean[0]);
        this.logger.debug((Object)("Service DN " + dn));
        configurationBean.setVomsServiceDN(dn);
        if (servicePort != null) {
            this.logger.debug((Object)"Service Port = ");
            configurationBean.setVomsServicePort(servicePort);
        }
        return configurationBean;
    }
}

