/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.ss;

import gr.uoa.di.madgik.environment.exception.EnvironmentStorageSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.ss.IStorageSystemProvider;
import java.io.File;
import java.net.URL;

public class StorageSystemProvider
implements IStorageSystemProvider {
    private static IStorageSystemProvider StaticProvider = null;
    private static final Object lockMe = new Object();
    private IStorageSystemProvider Provider = null;
    private EnvHintCollection InitHints = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStorageSystemProvider Init(String ProviderName, EnvHintCollection Hints) throws EnvironmentValidationException {
        try {
            Object object = lockMe;
            synchronized (object) {
                if (StaticProvider == null) {
                    if (ProviderName.equals(StorageSystemProvider.class.getName())) {
                        throw new EnvironmentValidationException("Class " + StorageSystemProvider.class.getName() + " cannot be defined as provider");
                    }
                    Class<?> c = Class.forName(ProviderName);
                    Object o = c.newInstance();
                    if (!(o instanceof IStorageSystemProvider)) {
                        throw new EnvironmentValidationException("");
                    }
                    StorageSystemProvider prov = new StorageSystemProvider();
                    prov.Provider = (IStorageSystemProvider)o;
                    prov.InitHints = Hints;
                    prov.Provider.SessionInit(Hints);
                    StaticProvider = prov;
                }
            }
            return StaticProvider;
        }
        catch (Exception ex) {
            throw new EnvironmentValidationException("Could not initialize Storage System Provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInit() {
        Object object = lockMe;
        synchronized (object) {
            return StaticProvider != null;
        }
    }

    @Override
    public void SessionInit(EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (this.Provider == null) {
            throw new EnvironmentStorageSystemException("Provider not initialized");
        }
        this.Provider.SessionInit(this.MergeHints(Hints));
    }

    @Override
    public File Retrieve(String ID, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (this.Provider == null) {
            throw new EnvironmentStorageSystemException("Provider not initialized");
        }
        return this.Provider.Retrieve(ID, this.MergeHints(Hints));
    }

    @Override
    public void Delete(String ID, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (this.Provider == null) {
            throw new EnvironmentStorageSystemException("Provider not initialized");
        }
        this.Provider.Delete(ID, this.MergeHints(Hints));
    }

    @Override
    public String Store(File file, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (this.Provider == null) {
            throw new EnvironmentStorageSystemException("Provider not initialized");
        }
        return this.Provider.Store(file, this.MergeHints(Hints));
    }

    @Override
    public String Store(URL location, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (this.Provider == null) {
            throw new EnvironmentStorageSystemException("Provider not initialized");
        }
        return this.Provider.Store(location, this.MergeHints(Hints));
    }

    @Override
    public File GetLocalFSBufferLocation(EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (this.Provider == null) {
            throw new EnvironmentStorageSystemException("Provider not initialized");
        }
        return this.Provider.GetLocalFSBufferLocation(this.MergeHints(Hints));
    }

    private EnvHintCollection MergeHints(EnvHintCollection Hints) {
        if (this.InitHints == null && Hints == null) {
            return new EnvHintCollection();
        }
        if (this.InitHints == null) {
            return Hints;
        }
        if (Hints == null) {
            return this.InitHints;
        }
        return this.InitHints.Merge(Hints);
    }
}

