/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.accounting;

import gr.uoa.di.madgik.environment.accounting.IAccountingFrameworkProvider;
import gr.uoa.di.madgik.environment.accounting.record.ExecutionUsageRecord;
import gr.uoa.di.madgik.environment.exception.EnvironmentReportingException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;

public class AccountingFrameworkProvider
implements IAccountingFrameworkProvider {
    private static IAccountingFrameworkProvider StaticProvider = null;
    private static final Object lockMe = new Object();
    private IAccountingFrameworkProvider Provider = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAccountingFrameworkProvider init(String ProviderName) throws EnvironmentValidationException {
        try {
            Object object = lockMe;
            synchronized (object) {
                if (StaticProvider == null) {
                    if (ProviderName.equals(AccountingFrameworkProvider.class.getName())) {
                        throw new EnvironmentValidationException("Class " + AccountingFrameworkProvider.class.getName() + " cannot be defined as accounting provider");
                    }
                    if (ProviderName == null || ProviderName.trim().equals("")) {
                        throw new EnvironmentValidationException("Provider name has not been specified correctly: " + ProviderName);
                    }
                    Class<?> c = Class.forName(ProviderName);
                    Object o = c.newInstance();
                    if (!(o instanceof IAccountingFrameworkProvider)) {
                        throw new EnvironmentValidationException("Class" + ProviderName + " is not an accounting provider");
                    }
                    AccountingFrameworkProvider prov = new AccountingFrameworkProvider();
                    prov.Provider = (IAccountingFrameworkProvider)o;
                    prov.SessionInit();
                    StaticProvider = prov;
                }
            }
            return StaticProvider;
        }
        catch (Exception ex) {
            throw new EnvironmentValidationException("Could not initialize Accounting Provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInit() {
        Object object = lockMe;
        synchronized (object) {
            return StaticProvider != null;
        }
    }

    @Override
    public void SessionInit() throws Exception {
        if (this.Provider == null) {
            throw new EnvironmentReportingException("Accounting Provider not initialized");
        }
        this.Provider.SessionInit();
    }

    @Override
    public void Send(ExecutionUsageRecord record) throws Exception {
        if (this.Provider == null) {
            throw new EnvironmentReportingException("Accounting Provider not initialized");
        }
        this.Provider.Send(record);
    }
}

