/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.FileUtils;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IOutputParameter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import gr.uoa.di.madgik.ss.StorageSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileTransferPlanElement
extends PlanElementBase {
    private static Logger logger = Logger.getLogger(FileTransferPlanElement.class.getName());
    private String ID = UUID.randomUUID().toString();
    private String Name = FileTransferPlanElement.class.getSimpleName();
    public IInputParameter Input = null;
    public IOutputParameter Output = null;
    public TransferDirection Direction = TransferDirection.Store;
    public IInputParameter MoveTo = null;
    public String Permissions = null;
    public boolean IsExecutable = false;
    public StoreMode OutputStoreMode = StoreMode.StorageSystem;
    public String StoreUrlLocation = null;
    public AccessInfo accessInfo = new AccessInfo();

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            Element osmElement;
            Element permselement;
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            this.IsExecutable = DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)XML, (String)"isexec"));
            Element outelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"output");
            if (outelement == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            Element parelem = XMLUtils.GetChildElementWithName((Node)outelement, (String)"param");
            if (parelem == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.Output = (IOutputParameter)ParameterUtils.GetParameter(parelem);
            Element inelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"input");
            if (inelement == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            parelem = XMLUtils.GetChildElementWithName((Node)inelement, (String)"param");
            if (parelem == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.Input = (IInputParameter)ParameterUtils.GetParameter(parelem);
            Element directionelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"direction");
            if (directionelement == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            if (!XMLUtils.AttributeExists((Element)directionelement, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.Direction = TransferDirection.valueOf(XMLUtils.GetAttribute((Element)directionelement, (String)"value"));
            Element mvelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"mvto");
            if (mvelement != null) {
                parelem = XMLUtils.GetChildElementWithName((Node)mvelement, (String)"param");
                if (parelem == null) {
                    throw new ExecutionSerializationException("Provided serialization not valid");
                }
                this.MoveTo = (IInputParameter)ParameterUtils.GetParameter(parelem);
            }
            if ((permselement = XMLUtils.GetChildElementWithName((Node)XML, (String)"perms")) != null) {
                if (!XMLUtils.AttributeExists((Element)permselement, (String)"value").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization not valid");
                }
                this.Permissions = XMLUtils.GetAttribute((Element)permselement, (String)"value");
            }
            if ((osmElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"outputStoreMode")) != null) {
                if (!XMLUtils.AttributeExists((Element)osmElement, (String)"value").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization not valid");
                }
                this.OutputStoreMode = StoreMode.valueOf(XMLUtils.GetAttribute((Element)osmElement, (String)"value"));
            }
            if (this.OutputStoreMode.equals((Object)StoreMode.Url)) {
                Element portElement;
                Element slElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"storeUrlLocation");
                if (slElement == null) {
                    throw new ExecutionSerializationException("Provided serialization not valid");
                }
                if (!XMLUtils.AttributeExists((Element)slElement, (String)"value").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization not valid");
                }
                this.StoreUrlLocation = XMLUtils.GetAttribute((Element)slElement, (String)"value");
                Element aiElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"accessInfo");
                Element userIdElement = XMLUtils.GetChildElementWithName((Node)aiElement, (String)"userId");
                if (userIdElement != null) {
                    this.accessInfo.userId = XMLUtils.GetAttribute((Element)userIdElement, (String)"value");
                    Element passwordElement = XMLUtils.GetChildElementWithName((Node)aiElement, (String)"password");
                    if (passwordElement == null) {
                        throw new ExecutionSerializationException("Provided serialization not valid");
                    }
                    this.accessInfo.password = XMLUtils.GetAttribute((Element)passwordElement, (String)"value");
                }
                if ((portElement = XMLUtils.GetChildElementWithName((Node)aiElement, (String)"port")) != null) {
                    this.accessInfo.port = Integer.parseInt(XMLUtils.GetAttribute((Element)portElement, (String)"value"));
                }
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.FileTransfer;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\" isexec=\"" + this.IsExecutable + "\">");
        buf.append("<input>");
        buf.append(this.Input.ToXML());
        buf.append("</input>");
        buf.append("<output>");
        buf.append(this.Output.ToXML());
        buf.append("</output>");
        if (this.MoveTo != null) {
            buf.append("<mvto>");
            buf.append(this.MoveTo.ToXML());
            buf.append("</mvto>");
        }
        if (this.Permissions != null && this.Permissions.trim().length() != 0) {
            buf.append("<perms value=\"" + this.Permissions + "\"/>");
        }
        buf.append("<direction value=\"" + this.Direction.toString() + "\"/>");
        buf.append("<outputStoreMode value=\"" + this.OutputStoreMode.toString() + "\"/>");
        if (this.OutputStoreMode.equals((Object)StoreMode.Url)) {
            buf.append("<storeUrlLocation value=\"" + this.StoreUrlLocation + "\"/>");
            buf.append("<accessInfo>");
            if (this.accessInfo.userId != null) {
                buf.append("<userId value=\"" + this.accessInfo.userId + "\"/>");
                buf.append("<password value=\"" + this.accessInfo.password + "\"/>");
            }
            if (this.accessInfo.port != -1) {
                buf.append("<port value=\"" + this.accessInfo.port + "\"/>");
            }
            buf.append("</accessInfo>");
        }
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Input == null) {
            throw new ExecutionValidationException("Input parameter not provided");
        }
        if (this.Output == null) {
            throw new ExecutionValidationException("Output parameter not provided");
        }
        this.Input.Validate();
        this.Output.Validate();
        if (this.MoveTo != null) {
            this.MoveTo.Validate();
        }
        if (this.Direction != TransferDirection.Retrieve && this.MoveTo != null) {
            throw new ExecutionValidationException("Move to is only supported for " + (Object)((Object)TransferDirection.Retrieve) + " operations");
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Output.GetModifiedVariableNames());
        vars.addAll(this.Input.GetModifiedVariableNames());
        if (this.MoveTo != null) {
            vars.addAll(this.MoveTo.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Output.GetNeededVariableNames());
        vars.addAll(this.Input.GetNeededVariableNames());
        if (this.MoveTo != null) {
            vars.addAll(this.MoveTo.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting");
        }
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 3, "Starting Execution of " + this.Name));
        }
        try {
            String outputValue = null;
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "Contacting Storage System"));
            }
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            switch (this.Direction) {
                case Retrieve: {
                    File sourceFile;
                    String inputValue = DataTypeUtils.GetValueAsString(this.Input.GetParameterValue(Handle));
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Retrieveing ID " + inputValue);
                    }
                    outputValue = StorageSystem.Retrieve((String)inputValue, (EnvHintCollection)Handle.GetPlan().EnvHints).getAbsolutePath();
                    if (this.MoveTo == null) break;
                    Object moveToName = this.MoveTo.GetParameterValue(Handle);
                    if (moveToName == null) {
                        throw new ExecutionValidationException("Provided move to name is null");
                    }
                    File targetFile = new File(moveToName.toString());
                    if (!targetFile.isAbsolute() && Handle.IsIsolationRequested()) {
                        targetFile = new File(Handle.GetIsolationInfo().GetBaseDirFile(), moveToName.toString());
                    }
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    if (targetFile.getParentFile() != null) {
                        targetFile.getParentFile().mkdirs();
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Retrieved and stored to local: " + targetFile.getAbsolutePath());
                    }
                    if (!(sourceFile = new File(outputValue)).renameTo(targetFile)) {
                        throw new ExecutionRunTimeException("Could not rename source file " + outputValue + " to " + moveToName.toString());
                    }
                    outputValue = moveToName.toString();
                    if (this.IsExecutable) {
                        FileUtils.MakeFileExecutable((File)targetFile);
                    }
                    if (this.Permissions == null) break;
                    FileUtils.MakeFilePermissions((File)targetFile, (String)this.Permissions);
                    break;
                }
                case Store: {
                    String inputValue = DataTypeUtils.GetValueAsString(this.Input.GetParameterValue(Handle));
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Storing file " + inputValue);
                    }
                    File targetinputFile = new File(DataTypeUtils.GetValueAsString(inputValue));
                    targetinputFile = Handle.GetIsolatedFile(targetinputFile).getAbsoluteFile();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Storing local: " + targetinputFile);
                    }
                    if (this.OutputStoreMode == StoreMode.StorageSystem) {
                        outputValue = StorageSystem.Store((File)targetinputFile, (EnvHintCollection)Handle.GetPlan().EnvHints);
                    } else {
                        logger.log(Level.INFO, "Storing to output location");
                        outputValue = this.storeOutputToLocation(targetinputFile);
                        logger.log(Level.INFO, "Stored to output location");
                    }
                    if (this.OutputStoreMode != StoreMode.StorageSystem) break;
                    Handle.GetPlan().CleanUpSS.Add(outputValue);
                    break;
                }
            }
            this.StopClock(PlanElementBase.ClockType.Children);
            this.StartClock(PlanElementBase.ClockType.Finilization);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Outcome was " + outputValue);
            }
            this.Output.SetParameterValue(Handle, outputValue);
            this.StopClock(PlanElementBase.ClockType.Finilization);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Caught exception: ", ex);
            ExceptionUtils.ThrowTransformedException(ex);
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 3, 3, "Finishing Execution of " + this.Name));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Exiting");
        }
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    private String constructRepositoryUrl() throws Exception {
        URL url = new URL(this.StoreUrlLocation);
        boolean usePort = false;
        boolean useAuthority = false;
        int portToUse = -1;
        if (url.getPort() <= 0 && this.accessInfo.port > 0) {
            usePort = true;
            portToUse = this.accessInfo.port;
        }
        if (url.getPort() > 0) {
            usePort = true;
            portToUse = this.accessInfo.port <= 0 ? url.getPort() : this.accessInfo.port;
        }
        if (this.accessInfo.userId != null) {
            useAuthority = true;
        }
        String afterProto = this.StoreUrlLocation.substring(this.StoreUrlLocation.indexOf("//") + 2);
        String afterHost = afterProto.substring(afterProto.indexOf("/") + 1);
        String newUrl = url.getProtocol() + "://" + (useAuthority ? this.accessInfo.userId + ":" + this.accessInfo.password + "@" : "") + url.getHost() + (usePort ? ":" + portToUse : "") + "/" + afterHost;
        return newUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String storeOutputToLocation(File output) throws Exception {
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        byte[] buf = new byte[1024];
        try {
            int i;
            String repositoryUrl = this.constructRepositoryUrl();
            logger.log(Level.FINER, "Storing output to location: " + repositoryUrl);
            URL url = new URL(repositoryUrl);
            URLConnection conn = url.openConnection();
            logger.log(Level.FINER, "Opened connection to ftp");
            bos = new BufferedOutputStream(conn.getOutputStream());
            logger.log(Level.FINER, "Opened output stream");
            bis = new BufferedInputStream(new FileInputStream(output));
            while ((i = bis.read(buf)) != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, i);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Could not close input stream");
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Could not upload output resource");
                }
            }
        }
        return this.StoreUrlLocation;
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        Set<String> ExcludeAvailableConstraint = this.GetModifiedVariableNames();
        this.Input.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        this.Output.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
    }

    public static void main(String[] args) throws Exception {
        FileTransferPlanElement ftr = new FileTransferPlanElement();
        ftr.StoreUrlLocation = "ftp://donald.di.uoa.gr:124";
        ftr.accessInfo.port = 123;
        String a = ftr.constructRepositoryUrl();
        System.out.println(a);
    }

    public static class AccessInfo {
        public String userId;
        public String password;
        public int port = -1;
    }

    public static enum StoreMode {
        StorageSystem,
        Url;

    }

    public static enum TransferDirection {
        Store,
        Retrieve;

    }
}

