/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTree;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LoopPlanElement
extends PlanElementBase {
    private static final Logger logger = Logger.getLogger(LoopPlanElement.class.getName());
    private String ID = UUID.randomUUID().toString();
    private String Name = LoopPlanElement.class.getSimpleName();
    public IPlanElement Root;
    public ConditionTree LoopCondition = null;

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element plannode = XMLUtils.GetChildElementWithName((Node)XML, (String)"planElement");
            if (plannode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            this.Root = PlanElementUtils.GetPlanElement(plannode);
            Element conditionnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"conditionTree");
            this.LoopCondition = new ConditionTree();
            this.LoopCondition.FromXML(conditionnode);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Loop;
    }

    @Override
    public IPlanElement Locate(String ID) {
        IPlanElement elem;
        if (this.ID.equals(ID)) {
            return this;
        }
        if (this.Root != null && (elem = this.Root.Locate(ID)) != null) {
            return elem;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        if (this.Root != null) {
            acts.addAll(this.Root.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append(this.LoopCondition.ToXML());
        buf.append(this.Root.ToXML());
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Root == null) {
            throw new ExecutionValidationException("root of node not set");
        }
        if (this.LoopCondition == null) {
            throw new ExecutionValidationException("root of node not set");
        }
        this.Root.Validate();
        this.LoopCondition.Validate();
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Root.GetModifiedVariableNames());
        vars.addAll(this.LoopCondition.GetModifiedVariableNames());
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Root.GetNeededVariableNames());
        vars.addAll(this.LoopCondition.GetNeededVariableNames());
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int CurrentStep = 1;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting");
        }
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep + 1, "Starting Execution of " + this.Name));
        }
        ++CurrentStep;
        this.InitializeCondition();
        this.StopClock(PlanElementBase.ClockType.Init);
        while (true) {
            this.StartClock(PlanElementBase.ClockType.Init);
            if (!this.LoopCondition.EvaluateCondition(Handle)) {
                if (Handle.GetPlan().Config.ChokeProgressReporting) break;
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Condition Evaluation of " + this.Name + " set loop break"));
                break;
            }
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Condition Evaluation of " + this.Name + " set loop continue"));
            }
            this.CheckStatus(Handle);
            try {
                if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                    Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep + 1, "Starting Execution of subelement for the " + (CurrentStep - 1) + " time"));
                }
                ++CurrentStep;
                this.StopClock(PlanElementBase.ClockType.Init);
                this.StartClock(PlanElementBase.ClockType.Children);
                this.Root.Execute(Handle);
                this.StopClock(PlanElementBase.ClockType.Children);
            }
            catch (ExecutionBreakException ex) {
                if (Handle.GetPlan().Config.ChokeProgressReporting) break;
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Received break exception. Breaking the loop"));
                break;
            }
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep, "Finishing Execution of " + this.Name));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Exiting");
        }
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    private void InitializeCondition() {
        this.LoopCondition.InitializeCondition();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        this.Root.ValidatePreExecution(Handle);
        this.LoopCondition.ValidatePreExecution(Handle);
    }
}

