/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.DataTypeReflectable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.utils.ReflectableAnalyzer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterReflectableFromTemplateFilter
extends ParameterFilterBase {
    private static Logger logger = Logger.getLogger(ParameterReflectableFromTemplateFilter.class.getName());
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;
    public String FilteredVariableName = null;
    public String TemplateVariableName = null;

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.FilteredVariableName);
        vars.add(this.TemplateVariableName);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.StoreOutputVariableName);
        return vars;
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableName == null || this.FilteredVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.TemplateVariableName == null || this.TemplateVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("No output variable name defined to store output");
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!Handle.GetPlan().Variables.Contains(this.TemplateVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        ndt = Handle.GetPlan().Variables.Get(this.TemplateVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.TemplateVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (this.StoreOutput) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (Handle.GetPlan().Variables.Contains(storeVarName)) continue;
                throw new ExecutionValidationException("Needed parameter to store output not present");
            }
        }
        this.TokenMappingValidate();
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
            NamedDataType ndtx = Handle.GetPlan().Variables.Get(this.TemplateVariableName);
            String value = ndt.Value.GetStringValue();
            String template = ndtx.Value.GetStringValue();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "template string is " + template);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Value string is " + value);
            }
            Document docValue = XMLUtils.Deserialize((String)value);
            Document docTemplate = XMLUtils.Deserialize((String)template);
            Element reflTemplateElement = docTemplate.getDocumentElement();
            if (reflTemplateElement == null) {
                throw new ExecutionValidationException("invalid template provided");
            }
            if (reflTemplateElement.getNodeName().equals("refl")) {
                ReflectableAnalyzer anal = new ReflectableAnalyzer();
                return anal.PopulateReflectableFromTemplate(template, value, 0, this.TokenMapping);
            }
            if (reflTemplateElement.getNodeName().equals("array")) {
                List reflValueElements;
                DataTypeArray arr = new DataTypeArray();
                arr.SetArrayClassCode("[" + (Object)((Object)IDataType.DataTypes.Reflectable));
                ArrayList<DataTypeReflectable> refls = new ArrayList<DataTypeReflectable>();
                if (!XMLUtils.AttributeExists((Element)reflTemplateElement, (String)"name").booleanValue()) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                if (!XMLUtils.AttributeExists((Element)reflTemplateElement, (String)"ns").booleanValue()) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                Element itemReflTemplateElement = XMLUtils.GetChildElementWithName((Node)reflTemplateElement, (String)"refl");
                if (itemReflTemplateElement == null) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                if (!XMLUtils.AttributeExists((Element)itemReflTemplateElement, (String)"name").booleanValue()) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                if (!XMLUtils.AttributeExists((Element)itemReflTemplateElement, (String)"ns").booleanValue()) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Checking value element (" + docValue.getDocumentElement() + ") for childen of name (" + XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"name") + ")");
                }
                if ((reflValueElements = XMLUtils.GetChildElementsWithNameAndNamespace((Node)docValue.getDocumentElement(), (String)XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"name"), (String)XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"ns"))) == null) {
                    throw new ExecutionValidationException("invalid value for template provided");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Number ot reflectables in array is " + reflValueElements.size());
                }
                for (int i = 0; i < reflValueElements.size(); ++i) {
                    ReflectableAnalyzer anal = new ReflectableAnalyzer();
                    refls.add(anal.PopulateReflectableFromTemplate(XMLUtils.Serialize((Node)itemReflTemplateElement), value, i, this.TokenMapping));
                }
                arr.SetValue(refls.toArray(new DataTypeReflectable[0]));
                return arr;
            }
            throw new ExecutionValidationException("invalid template provided");
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not extract value", ex);
        }
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableName = XMLUtils.GetChildText((Node)tmp);
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"templateVariable");
            if (tmp == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.TemplateVariableName = XMLUtils.GetChildText((Node)tmp);
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        if (this.FilteredVariableName == null) {
            buf.append("<filteredVariable/>");
        } else {
            buf.append("<filteredVariable>" + this.FilteredVariableName + "</filteredVariable>");
        }
        if (this.TemplateVariableName == null) {
            buf.append("<templateVariable/>");
        } else {
            buf.append("<templateVariable>" + this.TemplateVariableName + "</templateVariable>");
        }
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.ReflectableFromTemplate;
    }
}

