/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable.ws;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.invocable.ArgumentBase;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSOAPArgument
extends ArgumentBase {
    @Override
    public void Validate() throws ExecutionValidationException {
        super.Validate();
    }

    @Override
    public ArgumentBase.ArgumentType GetArgumentType() {
        return ArgumentBase.ArgumentType.WSSOAP;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<argument type=\"" + this.GetArgumentType().toString() + "\" order=\"" + this.Order + "\" name=\"" + this.ArgumentName + "\">");
        buf.append(this.Parameter.ToXML());
        buf.append("</argument>");
        return buf.toString();
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.ArgumentName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"name");
            Element paramelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"param");
            if (paramelem == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Parameter = (IInputParameter)ParameterUtils.GetParameter(paramelem);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }
}

