/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.condor;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IExternalFilter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JobQueueOutputCheckExternalFilter
implements IExternalFilter {
    private static Logger logger = Logger.getLogger(JobQueueOutputCheckExternalFilter.class.getName());
    public boolean StoreOutput = false;
    public String JobOutputVariableName = null;
    public String JobOutputUpdateVariableName = null;
    public boolean ClearUp = false;
    public boolean FinalOutcome = false;

    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobOutputVariableName);
        vars.add(this.JobOutputUpdateVariableName);
        return vars;
    }

    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobOutputUpdateVariableName);
        return vars;
    }

    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    public void Validate() throws ExecutionValidationException {
        if (this.JobOutputVariableName == null || this.JobOutputVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.StoreOutput && (this.JobOutputUpdateVariableName == null || this.JobOutputUpdateVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("Needed parameter is not provided");
        }
    }

    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.JobOutputVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.JobOutputVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.JobOutputVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!Handle.GetPlan().Variables.Contains(this.JobOutputUpdateVariableName)) {
            throw new ExecutionValidationException("Needed parameter to store output not present");
        }
    }

    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    public boolean SupportsOnLineFiltering() {
        return false;
    }

    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            if (this.ClearUp) {
                return "";
            }
            if (this.FinalOutcome) {
                String output = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobOutputVariableName).Value.GetValue());
                if (output.trim().length() == 0) {
                    return false;
                }
                return true;
            }
            String output = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobOutputVariableName).Value.GetValue());
            String update = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobOutputUpdateVariableName).Value.GetValue());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrieved queue output is : \n" + output);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrieved queue update is : \n" + update);
            }
            if (output.trim().length() == 0) {
                return update.trim();
            }
            return update.trim() + "-" + output.trim();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve job queue output", (Throwable)ex);
        }
    }

    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    public String ToXML() throws ExecutionSerializationException {
        String outputvarString = "";
        if (this.JobOutputUpdateVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.JobOutputUpdateVariableName + "\"";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<external type=\"" + this.getClass().getName() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredVariable name=\"" + this.JobOutputVariableName + "\"/>");
        buf.append("<clearUp value=\"" + this.ClearUp + "\"/>");
        buf.append("<final value=\"" + this.FinalOutcome + "\"/>");
        buf.append("</external>");
        return buf.toString();
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.JobOutputUpdateVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if (!XMLUtils.AttributeExists((Element)(tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")), (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.JobOutputVariableName = XMLUtils.GetAttribute((Element)tmp, (String)"name");
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"clearUp");
            if (!XMLUtils.AttributeExists((Element)tmp, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.ClearUp = DataTypeUtils.GetValueAsBoolean((Object)XMLUtils.GetAttribute((Element)tmp, (String)"value"));
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"final");
            if (!XMLUtils.AttributeExists((Element)tmp, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FinalOutcome = DataTypeUtils.GetValueAsBoolean((Object)XMLUtils.GetAttribute((Element)tmp, (String)"value"));
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", (Throwable)ex);
        }
    }
}

