/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.grid;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IExternalFilter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.JobStatusBreakLoopFilter;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.JobStatusExternalFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JobStatusSuccessFilter
implements IExternalFilter {
    private static Logger logger = Logger.getLogger(JobStatusBreakLoopFilter.class.getName());
    public boolean StoreOutput = false;
    public String JobStatusVariableName = null;
    public String JobStatusOutputVariableName = null;

    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobStatusVariableName);
        return vars;
    }

    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobStatusOutputVariableName);
        return vars;
    }

    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    public void Validate() throws ExecutionValidationException {
        if (this.JobStatusVariableName == null || this.JobStatusVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.StoreOutput && (this.JobStatusOutputVariableName == null || this.JobStatusOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("Needed parameter is not provided");
        }
    }

    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.JobStatusVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.JobStatusVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.JobStatusVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!Handle.GetPlan().Variables.Contains(this.JobStatusOutputVariableName)) {
            throw new ExecutionValidationException("Needed parameter to store output not present");
        }
    }

    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    public boolean SupportsOnLineFiltering() {
        return false;
    }

    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            String output = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobStatusVariableName).Value.GetValue());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Input is " + output);
            }
            JobStatusExternalFilter.JobStatus s = JobStatusExternalFilter.JobStatus.valueOf(output);
            switch (s) {
                case Done: 
                case Aborted: 
                case Cancelled: 
                case Cleared: 
                case Other: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "returning true, status=" + s.toString());
                    }
                    return true;
                }
                case Ready: 
                case Running: 
                case Scheduled: 
                case Submitted: 
                case Waiting: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "returning false, status=" + s.toString());
                    }
                    return false;
                }
            }
            throw new ExecutionValidationException("Unrecognized job status " + (Object)((Object)s));
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve job status", (Throwable)ex);
        }
    }

    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    public String ToXML() throws ExecutionSerializationException {
        String outputvarString = "";
        if (this.JobStatusOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.JobStatusOutputVariableName + "\"";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<external type=\"" + this.getClass().getName() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredVariable name=\"" + this.JobStatusVariableName + "\"/>");
        buf.append("</external>");
        return buf.toString();
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.JobStatusOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if (!XMLUtils.AttributeExists((Element)(tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")), (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.JobStatusVariableName = XMLUtils.GetAttribute((Element)tmp, (String)"name");
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", (Throwable)ex);
        }
    }
}

