/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.jdl;

import gr.uoa.di.madgik.commons.utils.FileUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.IParsedInfo;
import gr.uoa.di.madgik.workflow.adaptor.utils.IWorkflowParser;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLDAGExtractor;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLJobExtractor;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLParsingUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.ParsedJDLInfo;
import gr.uoa.di.madgik.workflow.exception.WorkflowInternalErrorException;
import gr.uoa.di.madgik.workflow.exception.WorkflowSerializationException;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDLParser
implements IWorkflowParser {
    private static Logger logger = Logger.getLogger(JDLParser.class.getName());
    public ParsedJDLInfo Internal = null;

    @Override
    public void Parse(File serialization) throws WorkflowSerializationException, WorkflowValidationException {
        String payload = null;
        try {
            payload = FileUtils.ReadFileToString((File)serialization);
        }
        catch (Exception ex) {
            throw new WorkflowSerializationException("Could not parse jdl file", ex);
        }
        this.Parse(payload);
    }

    @Override
    public void Parse(String serialization) throws WorkflowSerializationException, WorkflowValidationException {
        String jdlSer = JDLParsingUtils.Trim(serialization);
        jdlSer = JDLParsingUtils.StripComments(jdlSer);
        String jdlBlock = JDLParsingUtils.GetDefinitionBlock(jdlSer);
        Map<String, String> KeyValues = JDLParsingUtils.GetKeyValues(jdlBlock);
        logger.log(Level.INFO, "JDL key-values: " + KeyValues);
        try {
            this.ProcessKeys(KeyValues);
        }
        catch (WorkflowInternalErrorException ex) {
            throw new WorkflowSerializationException("Could not parse provided jdl serialization", ex);
        }
    }

    @Override
    public IParsedInfo GetParsedInfo() {
        return this.Internal;
    }

    private void ProcessKeys(Map<String, String> KeyValues) throws WorkflowValidationException, WorkflowInternalErrorException {
        ParsedJDLInfo.JobDescriptionType jdt = ParsedJDLInfo.JobDescriptionType.valueOf(JDLParsingUtils.StripQuotes(JDLParsingUtils.GetKeyValue(KeyValues, ParsedJDLInfo.KnownKeys.Type, true)));
        switch (jdt) {
            case DAG: {
                JDLDAGExtractor extr = new JDLDAGExtractor(KeyValues);
                this.Internal = extr.ProcessKeys();
                break;
            }
            case Job: {
                JDLJobExtractor extr = new JDLJobExtractor(KeyValues);
                this.Internal = extr.ProcessKeys();
                break;
            }
            default: {
                throw new WorkflowValidationException("Unrecognized job type");
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Parsed info is " + this.Internal.ToXML());
        }
    }
}

