/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.directory;

import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.workflow.adaptor.IWorkflowAdaptor;
import gr.uoa.di.madgik.workflow.directory.ExecutionDirectory;
import gr.uoa.di.madgik.workflow.reporter.ExecutionReporter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionObserver
implements Observer {
    private static final Logger logger = Logger.getLogger(ExecutionObserver.class.getName());
    private static final long DefaultLease = 259200000L;
    private final Object synchEvents = new Object();
    private String ExecutionID = null;
    private Queue<ExecutionStateEvent> Events = new LinkedList<ExecutionStateEvent>();
    private boolean isCompleted = false;
    private ExecutionHandle Handle = null;
    private ExecutionDirectory.DirectoryEntryType Type = ExecutionDirectory.DirectoryEntryType.JDL;
    private IWorkflowAdaptor Adaptor = null;
    private long EndTime = 0L;
    private long Lease = 259200000L;
    private boolean StorageSystemCleanupPerformed = false;
    private boolean reportMessages = false;
    private Object synchCompletion = null;

    public ExecutionObserver(String ExecutionID, ExecutionDirectory.DirectoryEntryType Type2, long Lease, ExecutionHandle Handle, IWorkflowAdaptor Adaptor) {
        this.ExecutionID = ExecutionID;
        this.Handle = Handle;
        this.Type = Type2;
        this.Adaptor = Adaptor;
        this.Lease = Lease;
        this.reportMessages = false;
    }

    public ExecutionObserver(String ExecutionID, ExecutionDirectory.DirectoryEntryType Type2, long Lease, ExecutionHandle Handle, IWorkflowAdaptor Adaptor, boolean reportMessages) {
        this(ExecutionID, Type2, Lease, Handle, Adaptor);
        this.reportMessages = reportMessages;
    }

    public ExecutionObserver(String ExecutionID, ExecutionDirectory.DirectoryEntryType Type2, long Lease, ExecutionHandle Handle, IWorkflowAdaptor Adaptor, boolean reportMessages, Object synchCompletion) {
        this(ExecutionID, Type2, Lease, Handle, Adaptor, reportMessages);
        this.synchCompletion = synchCompletion;
    }

    public boolean HasPerformedStorageSystermCleanup() {
        return this.StorageSystemCleanupPerformed;
    }

    public void PerformedStorageSystermCleanup() {
        this.StorageSystemCleanupPerformed = true;
        this.Handle.CleanUpStorageSystem();
    }

    public IWorkflowAdaptor GetAdaptor() {
        return this.Adaptor;
    }

    public ExecutionHandle GetExecutionHandle() {
        return this.Handle;
    }

    public ExecutionDirectory.DirectoryEntryType GetWorkflowType() {
        return this.Type;
    }

    public String GetExecutionID() {
        return this.ExecutionID;
    }

    public long GetLease() {
        if (this.Lease <= 0L) {
            return 259200000L;
        }
        return this.Lease;
    }

    public boolean ShouldCleanup() {
        if (!this.isCompleted) {
            return false;
        }
        if (this.EndTime == 0L) {
            return false;
        }
        long diff = Calendar.getInstance().getTimeInMillis() - this.EndTime;
        return diff > this.GetLease();
    }

    public boolean IsCompleted() {
        return this.isCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutionStateEvent> GetEvents() {
        ArrayList<ExecutionStateEvent> received = new ArrayList<ExecutionStateEvent>();
        Object object = this.synchEvents;
        synchronized (object) {
            ExecutionStateEvent ev;
            while (!this.Events.isEmpty() && (ev = this.Events.poll()) != null) {
                received.add(ev);
            }
        }
        return received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        Object object;
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            return;
        }
        if (!(arg instanceof ExecutionStateEvent)) {
            return;
        }
        switch (((ExecutionStateEvent)arg).GetEventName()) {
            case ExecutionCompleted: {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Execution " + this.ExecutionID + " got event " + arg.getClass().getSimpleName());
                }
                if (this.synchCompletion != null) {
                    object = this.synchCompletion;
                    synchronized (object) {
                        this.isCompleted = true;
                        this.synchCompletion.notifyAll();
                    }
                }
                this.isCompleted = true;
                this.EndTime = Calendar.getInstance().getTimeInMillis();
                if (!this.reportMessages) break;
                ExecutionReporter.ReportExecutionStatus((ExecutionStateEvent)arg, this.ExecutionID, this.Type, this.Handle.GetPlan().EnvHints);
                break;
            }
            case ExecutionCancel: 
            case ExecutionPause: 
            case ExecutionResume: 
            case ExecutionStarted: 
            case ExecutionPerformance: 
            case ExecutionExternalProgress: 
            case ExecutionProgress: {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Execution " + this.ExecutionID + " got event " + arg.getClass().getSimpleName());
                }
                if (!this.reportMessages) break;
                ExecutionReporter.ReportExecutionStatus((ExecutionStateEvent)arg, this.ExecutionID, this.Type, this.Handle.GetPlan().EnvHints);
                break;
            }
            default: {
                if (!logger.isLoggable(Level.WARNING)) break;
                logger.log(Level.WARNING, "Execution " + this.ExecutionID + " got unrecognized event " + arg.getClass().getSimpleName());
            }
        }
        object = this.synchEvents;
        synchronized (object) {
            this.Events.add((ExecutionStateEvent)arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Cleanup() {
        if (this.Handle != null) {
            this.Handle.Cancel();
        }
        Object object = this.synchEvents;
        synchronized (object) {
            this.Events.clear();
        }
    }
}

