/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BreakPlanElement
extends PlanElementBase {
    private static final Logger logger = Logger.getLogger(BreakPlanElement.class.getName());
    private String ID = UUID.randomUUID().toString();
    private String Name = BreakPlanElement.class.getSimpleName();
    public String Message = null;

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"message");
            if (tmp != null) {
                this.Message = XMLUtils.GetChildText((Node)tmp);
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Break;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        if (this.Message != null && this.Message.trim().length() != 0) {
            buf.append("<message>" + this.Message + "</message>");
        }
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        return new HashSet<String>();
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionCancelException, ExecutionInternalErrorException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting");
        }
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 1, "Execution break from element " + this.GetName() + (this.Message == null ? "" : " (" + this.Message + ")")));
        }
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
        throw new ExecutionBreakException("Execution break from element " + this.GetName() + (this.Message == null ? "" : " (" + this.Message + ")"));
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
    }
}

