/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamedDataType {
    public String Name = null;
    public String Token = null;
    public Boolean IsAvailable = false;
    public IDataType Value = null;

    public String ToXML() throws ExecutionSerializationException {
        if (this.Value == null) {
            throw new ExecutionSerializationException("Data type cannot be null");
        }
        StringBuilder buf = new StringBuilder();
        String tokenString = "token=\"" + this.Token + "\"";
        if (this.Token == null) {
            tokenString = "";
        }
        buf.append("<ndt name=\"" + this.Name + "\" available=\"" + this.IsAvailable.toString() + "\" " + tokenString + ">");
        buf.append(this.Value.ToXML());
        buf.append("</ndt>");
        return buf.toString();
    }

    public void FromXML(String XML) throws ExecutionSerializationException {
        try {
            this.FromXML(XMLUtils.Deserialize((String)XML).getDocumentElement());
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided document", ex);
        }
    }

    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"name").booleanValue() || !XMLUtils.AttributeExists((Element)XML, (String)"available").booleanValue()) {
                throw new ExecutionSerializationException("Not a valid serialization of a named data type");
            }
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            this.Token = XMLUtils.AttributeExists((Element)XML, (String)"token") != false ? XMLUtils.GetAttribute((Element)XML, (String)"token") : null;
            this.IsAvailable = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XML, (String)"available"));
            Element val = XMLUtils.GetChildElementWithName((Node)XML, (String)"dt");
            if (val == null) {
                throw new ExecutionSerializationException("Not a valid serialization of a named data type");
            }
            this.Value = DataTypeUtils.GetDataType(val);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize named data type from provided serialization", ex);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof NamedDataType)) {
            return false;
        }
        if (!this.Name.equals(((NamedDataType)o).Name)) {
            return false;
        }
        if (!this.Token.equals(((NamedDataType)o).Token)) {
            return false;
        }
        if (!this.IsAvailable.toString().equals(((NamedDataType)o).IsAvailable.toString())) {
            return false;
        }
        return this.Value.equals(((NamedDataType)o).Value);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

