/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.net.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTypeResultSet
implements IDataType {
    private URI Value = null;

    @Override
    public boolean CanSuggestDataTypeClass() {
        return true;
    }

    @Override
    public Class<?> GetDataTypeClass() {
        return URI.class;
    }

    @Override
    public IDataType.DataTypes GetDataTypeEnum() {
        return IDataType.DataTypes.ResultSet;
    }

    @Override
    public String GetStringValue() throws ExecutionSerializationException {
        try {
            if (this.Value == null) {
                return "";
            }
            return this.Value.toString();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not generate string value", ex);
        }
    }

    @Override
    public Object GetValue() {
        return this.Value;
    }

    @Override
    public void SetStringValue(String val) throws ExecutionValidationException, ExecutionSerializationException {
        if (val == null || val.trim().length() == 0) {
            this.SetValue(null);
        } else {
            URI loc = null;
            try {
                loc = DataTypeUtils.GetValueAsProxyLocator(val);
            }
            catch (Exception ex) {
                throw new ExecutionSerializationException("Could not generate locator", ex);
            }
            this.SetValue(loc);
        }
    }

    @Override
    public void SetValue(Object Value) throws ExecutionValidationException {
        if (Value == null) {
            this.Value = null;
        } else if (Value instanceof URI) {
            this.Value = DataTypeUtils.GetValueAsProxyLocator(Value);
        } else if (Value instanceof String) {
            this.Value = DataTypeUtils.GetValueAsProxyLocator(Value);
        } else {
            throw new ExecutionValidationException("Incompatible types. Expecting " + URI.class.getName() + " and found " + Value.getClass().getName());
        }
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetDataTypeEnum())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element valelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valelem == null) {
                this.SetValue(null);
            } else {
                this.SetValue(XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)valelem)));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("<dt type=\"" + this.GetDataTypeEnum().toString() + "\">");
            if (this.Value != null) {
                buf.append("<value>");
                buf.append(XMLUtils.DoReplaceSpecialCharachters((String)this.Value.toString()));
                buf.append("</value>");
            }
            buf.append("</dt>");
            return buf.toString();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize data type", ex);
        }
    }
}

