/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.event.ExecutionCancelStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionCompletedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionExternalProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionPauseStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionPerformanceReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionResumeStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStartedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.execution.plan.element.invocable.NozzleHandler;
import gr.uoa.di.madgik.execution.utils.BoundaryIsolationInfo;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.ss.StorageSystem;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionHandle
implements Observer {
    private static Logger logger = LoggerFactory.getLogger(ExecutionHandle.class);
    private Hashtable<ExecutionStateEvent.EventName, ExecutionStateEvent> Events = new Hashtable();
    private ExecutionPlan Plan = null;
    private HandleState State = HandleState.Ready;
    private boolean Completed = false;
    private boolean CompletedWithSuccess = false;
    private boolean CompletedWithError = false;
    private ExecutionException CompletionError = null;
    private final Object lockMe = new Object();
    private Set<NozzleHandler> AliveContextHandlers = new HashSet<NozzleHandler>();
    private BoundaryIsolationInfo IsolationInfo = null;
    private Object SynchActionsRunning = new Object();
    private int ActionsRunningWithingBoundary = 0;
    private String hostingNodeInfo = null;

    public ExecutionHandle(ExecutionPlan Plan, String hostingNodeInfo) {
        this.Init();
        this.Plan = Plan;
        this.hostingNodeInfo = hostingNodeInfo;
    }

    public String getHostingNodeInfo() {
        return this.hostingNodeInfo;
    }

    public void IncreaseActionsRunning() {
        ++this.ActionsRunningWithingBoundary;
    }

    public void DecreaseActionsRunning() {
        --this.ActionsRunningWithingBoundary;
        this.GetSynchActionsRunning().notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ForceRecheckOfPendingActions() {
        Object object = this.GetSynchActionsRunning();
        synchronized (object) {
            this.GetSynchActionsRunning().notifyAll();
        }
    }

    public Object GetSynchActionsRunning() {
        return this.SynchActionsRunning;
    }

    public int GetActionsRunning() {
        return this.ActionsRunningWithingBoundary;
    }

    public boolean IsCompleted() {
        return this.Completed;
    }

    public void AddContextHandler(NozzleHandler Handler) {
        this.AliveContextHandlers.add(Handler);
    }

    public File GetIsolatedFile(File original) {
        if (!this.IsIsolationRequested()) {
            return original;
        }
        if (original.isAbsolute()) {
            return original;
        }
        return new File(this.GetIsolationInfo().GetBaseDirFile(), original.toString());
    }

    public boolean IsIsolationRequested() {
        if (this.IsolationInfo == null) {
            return false;
        }
        return this.IsolationInfo.Isolate;
    }

    public void SetIsolationInfo(BoundaryIsolationInfo IsolationInfo) {
        this.IsolationInfo = IsolationInfo;
    }

    public BoundaryIsolationInfo GetIsolationInfo() {
        return this.IsolationInfo;
    }

    public void InitializeIsolation() throws ExecutionValidationException, ExecutionRunTimeException {
        this.IsolationInfo.InitializeIsolation(this, this.Plan.EnvHints);
    }

    public void FinalizeIsolation() throws ExecutionValidationException, ExecutionRunTimeException {
        this.IsolationInfo.FinalizeIsolation(this, this.Plan.EnvHints);
    }

    protected void SetIsCompleted(boolean IsCompleted) {
        this.Completed = IsCompleted;
    }

    public boolean IsCompletedWithSuccess() {
        return this.CompletedWithSuccess;
    }

    protected void SetIsCompletedWithSuccess(boolean IsCompletedWithSuccess) {
        this.CompletedWithSuccess = IsCompletedWithSuccess;
    }

    public boolean IsCompletedWithError() {
        return this.CompletedWithError;
    }

    protected void SetIsCompletedWithError(boolean IsCompletedWithError) {
        this.CompletedWithError = IsCompletedWithError;
    }

    public ExecutionException GetCompletionError() {
        return this.CompletionError;
    }

    protected void SetCompletionError(ExecutionException CompletionError) {
        this.CompletionError = CompletionError;
    }

    private void Init() {
        if (this.Events.size() != 0) {
            throw new IllegalStateException("Execution handle has already been initialized");
        }
        this.Events.put(ExecutionStateEvent.EventName.ExecutionCompleted, new ExecutionCompletedStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionStarted, new ExecutionStartedStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionPause, new ExecutionPauseStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionResume, new ExecutionResumeStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionCancel, new ExecutionCancelStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionProgress, new ExecutionProgressReportStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionExternalProgress, new ExecutionExternalProgressReportStateEvent());
        this.Events.put(ExecutionStateEvent.EventName.ExecutionPerformance, new ExecutionPerformanceReportStateEvent());
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionPause).addObserver(this);
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionResume).addObserver(this);
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionCancel).addObserver(this);
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionCompleted).addObserver(this);
    }

    public void RegisterObserver(Observer HandleObserver) {
        for (ExecutionStateEvent ev : this.GetEvents()) {
            ev.addObserver(HandleObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitEvent(ExecutionStateEvent Event) {
        if (this.Plan.Config.ChokeProgressReporting && (Event.GetEventName().equals((Object)ExecutionStateEvent.EventName.ExecutionProgress) || Event.GetEventName().equals((Object)ExecutionStateEvent.EventName.ExecutionExternalProgress)) || this.Plan.Config.ChokePerformanceReporting && Event.GetEventName().equals((Object)ExecutionStateEvent.EventName.ExecutionPerformance)) {
            return;
        }
        Object object = this.lockMe;
        synchronized (object) {
            ExecutionStateEvent e = this.GetEvent(Event.GetEventName());
            if (e == null) {
                return;
            }
            e.SetChanged();
            e.notifyObservers(Event);
        }
    }

    public ExecutionStateEvent GetEvent(ExecutionStateEvent.EventName Event) {
        return this.Events.get((Object)Event);
    }

    public Collection<ExecutionStateEvent> GetEvents() {
        return this.Events.values();
    }

    public ExecutionPlan GetPlan() {
        return this.Plan;
    }

    public HandleState GetHandleState() {
        return this.State;
    }

    protected void PlanRunning() {
        this.State = HandleState.Running;
    }

    protected void PlanCompleted() {
        this.State = HandleState.Completed;
    }

    public void Pause() {
        this.State = HandleState.Paused;
        this.EmitEvent(new ExecutionPauseStateEvent());
    }

    public void Resume() {
        this.State = HandleState.Running;
        this.EmitEvent(new ExecutionResumeStateEvent());
    }

    public void Cancel() {
        this.State = HandleState.Cancel;
        this.EmitEvent(new ExecutionCancelStateEvent());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            return;
        }
        if (arg instanceof ExecutionPauseStateEvent) {
            this.State = HandleState.Paused;
        }
        if (arg instanceof ExecutionResumeStateEvent) {
            this.State = HandleState.Running;
        }
        if (arg instanceof ExecutionCancelStateEvent) {
            this.State = HandleState.Cancel;
            this.ForceRecheckOfPendingActions();
        }
        if (arg instanceof ExecutionCompletedStateEvent) {
            this.ForceRecheckOfPendingActions();
        }
    }

    public void Dispose() {
        this.ForceRecheckOfPendingActions();
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionPause).deleteObserver(this);
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionResume).deleteObserver(this);
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionCancel).deleteObserver(this);
        this.Events.get((Object)ExecutionStateEvent.EventName.ExecutionCompleted).deleteObserver(this);
        for (ExecutionStateEvent ev : this.GetEvents()) {
            ev.deleteObservers();
        }
        logger.debug("Disposing alive context (" + this.AliveContextHandlers.size() + ")");
        for (NozzleHandler handler : this.AliveContextHandlers) {
            try {
                handler.Dispose();
            }
            catch (ExecutionInternalErrorException e) {
                logger.debug("Problem disposing context");
            }
        }
        this.AliveContextHandlers.clear();
    }

    public void CleanUpStorageSystem() {
        logger.debug("Cleaning up StorageSystem");
        HashSet<String> Exclude = new HashSet<String>();
        for (String s : this.Plan.CleanUpSSExclude) {
            if (this.GetPlan().Variables.Get(s) == null || !this.GetPlan().Variables.Get((String)s).IsAvailable.booleanValue()) continue;
            try {
                Exclude.add(DataTypeUtils.GetValueAsString(this.GetPlan().Variables.Get((String)s).Value.GetValue()));
            }
            catch (Exception ex) {}
        }
        for (String s : this.GetPlan().CleanUpSS) {
            if (Exclude.contains(s)) continue;
            try {
                logger.debug("Cleaning up Storage System of ID " + s);
                StorageSystem.Delete((String)s, (EnvHintCollection)this.GetPlan().EnvHints);
            }
            catch (Exception ex) {
                logger.warn("Could not remove from Storage System id " + s, (Throwable)ex);
            }
        }
    }

    public static enum HandleState {
        Ready,
        Running,
        Paused,
        Completed,
        Cancel;

    }
}

