/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IObjectConverter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTypeConvertable
implements IDataType {
    private String Value = null;
    private String Converter = null;

    @Override
    public boolean CanSuggestDataTypeClass() {
        return false;
    }

    @Override
    public Class<?> GetDataTypeClass() {
        return null;
    }

    @Override
    public IDataType.DataTypes GetDataTypeEnum() {
        return IDataType.DataTypes.Convertable;
    }

    @Override
    public String GetStringValue() throws ExecutionSerializationException {
        try {
            if (this.Value == null) {
                return "";
            }
            return this.Value.toString();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not generate string value", ex);
        }
    }

    @Override
    public Object GetValue() {
        return this;
    }

    public String GetConvertedValue() {
        return this.Value;
    }

    public void SetConvertedValue(String ConvertedValue) {
        this.Value = ConvertedValue;
    }

    public String GetConverter() {
        return this.Converter;
    }

    public void SetConverter(String Converter) {
        this.Converter = Converter;
    }

    @Override
    public void SetStringValue(String val) throws ExecutionValidationException, ExecutionSerializationException {
        if (val == null || val.trim().length() == 0) {
            this.SetValue(null);
        } else {
            this.SetValue(val);
        }
    }

    @Override
    public void SetValue(Object Value) throws ExecutionValidationException {
        String ErrorString = null;
        if (Value == null) {
            this.Value = null;
            return;
        }
        if (Value instanceof DataTypeConvertable) {
            this.Converter = ((DataTypeConvertable)Value).Converter;
            this.Value = ((DataTypeConvertable)Value).Value;
            return;
        }
        if (Value instanceof String) {
            this.Value = DataTypeUtils.GetValueAsString(Value);
            return;
        }
        if (this.Converter != null) {
            try {
                Object o = Class.forName(this.Converter).newInstance();
                if (o instanceof IObjectConverter) {
                    this.Value = DataTypeUtils.GetValueAsString(((IObjectConverter)o).Convert(Value));
                    return;
                }
            }
            catch (Exception ex) {
                ErrorString = ex.getMessage();
            }
        }
        throw new ExecutionValidationException("Incompatible types. Expecting String or somthing convertable through " + this.Converter + " and found " + Value.getClass().getName() + " with error from converter(" + ErrorString + ")");
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetDataTypeEnum())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element valelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valelem == null) {
                throw new ExecutionSerializationException("Provided Serialization is not valid");
            }
            Element elem = XMLUtils.GetChildElementWithName((Node)valelem, (String)"converter");
            if (elem == null) {
                throw new Exception("converter value not provided in serialization");
            }
            this.Converter = XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)elem));
            elem = XMLUtils.GetChildElementWithName((Node)valelem, (String)"converted");
            this.Value = elem == null ? null : XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)elem));
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<dt type=\"" + this.GetDataTypeEnum().toString() + "\">");
        buf.append("<value>");
        if (this.Value == null || this.Value.trim().length() == 0) {
            buf.append("<converted/>");
        } else {
            buf.append("<converted>" + XMLUtils.DoReplaceSpecialCharachters((String)this.Value) + "</converted>");
        }
        if (this.Converter == null || this.Converter.trim().length() == 0) {
            buf.append("<conv/>");
        } else {
            buf.append("<converter>" + XMLUtils.DoReplaceSpecialCharachters((String)this.Converter) + "</converter>");
        }
        buf.append("</value>");
        buf.append("</dt>");
        return buf.toString();
    }
}

