/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeConvertable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTypeArray
implements IDataType,
Iterable<IDataType> {
    private IDataType[] Value = null;
    private String ArrayClassCode = null;
    private String DefaultConverter = null;
    private String DefaultComponentType = null;

    @Override
    public Iterator<IDataType> iterator() {
        return Arrays.asList(this.Value).iterator();
    }

    public String GetArrayClassCode() {
        return this.ArrayClassCode;
    }

    public void SetArrayClassCode(String ArrayClassCode) {
        this.ArrayClassCode = ArrayClassCode;
    }

    public String GetDefaultConverter() {
        return this.DefaultConverter;
    }

    public void SetDefaultConverter(String DefaultConverter) {
        this.DefaultConverter = DefaultConverter;
    }

    public String GetDefaultComponentType() {
        return this.DefaultComponentType;
    }

    public void SetDefaultComponentType(String DefaultComponentType) {
        this.DefaultComponentType = DefaultComponentType;
    }

    @Override
    public boolean CanSuggestDataTypeClass() {
        return false;
    }

    @Override
    public Class<?> GetDataTypeClass() {
        return null;
    }

    @Override
    public IDataType.DataTypes GetDataTypeEnum() {
        return IDataType.DataTypes.Array;
    }

    @Override
    public String GetStringValue() throws ExecutionSerializationException {
        return this.ToXML();
    }

    @Override
    public void SetStringValue(String val) throws ExecutionValidationException, ExecutionSerializationException {
        this.FromXML(val);
    }

    public IDataType[] GetItems() {
        return this.Value;
    }

    @Override
    public Object GetValue() {
        if (this.ArrayClassCode == null || this.ArrayClassCode.trim().length() == 0) {
            throw new IllegalStateException("Array code has not been set");
        }
        if (this.Value == null) {
            return null;
        }
        Object valArray = null;
        try {
            int[] dims = new int[DataTypeUtils.CountDimentionsOfObjectArrayCode(this.GetArrayClassCode())];
            dims[0] = this.Value.length;
            valArray = Array.newInstance(DataTypeUtils.GetComponentTypeOfArrayInitializingCode(this.ArrayClassCode), dims);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize array of code " + this.GetArrayClassCode(), ex);
        }
        for (int i = 0; i < this.Value.length; ++i) {
            Array.set(valArray, i, this.Value[i].GetValue());
        }
        return valArray;
    }

    @Override
    public void SetValue(Object Value) throws ExecutionValidationException {
        if (this.ArrayClassCode == null || this.ArrayClassCode.trim().length() == 0) {
            throw new IllegalStateException("Array code has not been set");
        }
        if (Value == null) {
            this.Value = null;
            return;
        }
        if (Value instanceof IDataType[]) {
            this.Value = (IDataType[])Value;
            return;
        }
        if (Value instanceof String) {
            try {
                this.FromXML((String)Value);
                return;
            }
            catch (ExecutionSerializationException ex) {
                throw new ExecutionValidationException("Could not set value from infered XML serialization of array data type", ex);
            }
        }
        if (!Value.getClass().isArray() && !(Value instanceof DataTypeArray)) {
            throw new ExecutionValidationException("provided value is not an array");
        }
        int dimentions = DataTypeUtils.CountDimentionsOfObjectArrayCode(this.ArrayClassCode);
        if (dimentions == 1) {
            int length = 0;
            length = Value.getClass().isArray() ? Array.getLength(Value) : ((DataTypeArray)Value).Value.length;
            this.Value = DataTypeUtils.GetArrayOfDataType(DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(this.ArrayClassCode), length);
            for (int i = 0; i < length; ++i) {
                IDataType dtitem = DataTypeUtils.GetDataType(DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(this.ArrayClassCode));
                if (dtitem instanceof DataTypeConvertable && this.DefaultConverter != null) {
                    ((DataTypeConvertable)dtitem).SetConverter(this.DefaultConverter);
                }
                Object val = null;
                val = Value.getClass().isArray() ? Array.get(Value, i) : ((DataTypeArray)Value).Value[i].GetValue();
                dtitem.SetValue(val);
                this.Value[i] = dtitem;
            }
        } else {
            int length = 0;
            length = Value.getClass().isArray() ? Array.getLength(Value) : ((DataTypeArray)Value).Value.length;
            this.Value = DataTypeUtils.GetArrayOfDataType(IDataType.DataTypes.Array, length);
            for (int i = 0; i < length; ++i) {
                this.Value[i] = new DataTypeArray();
                ((DataTypeArray)this.Value[i]).SetDefaultConverter(this.DefaultConverter);
                ((DataTypeArray)this.Value[i]).SetDefaultComponentType(this.DefaultComponentType);
                ((DataTypeArray)this.Value[i]).SetArrayClassCode(this.ArrayClassCode.substring(1));
                Object val = null;
                val = Value.getClass().isArray() ? Array.get(Value, i) : ((DataTypeArray)Value).Value[i].GetValue();
                this.Value[i].SetValue(val);
            }
        }
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetDataTypeEnum())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element defconvelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"defConverter");
            this.DefaultConverter = defconvelem == null ? null : XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)defconvelem));
            Element defcompelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"defComponent");
            this.DefaultComponentType = defcompelem == null ? null : XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)defcompelem));
            Element valelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valelem == null) {
                throw new ExecutionSerializationException("provided serialization is not valid");
            }
            Element arrelem = XMLUtils.GetChildElementWithName((Node)valelem, (String)"array");
            if (arrelem == null) {
                throw new ExecutionSerializationException("provided serialization is not valid");
            }
            if (!XMLUtils.AttributeExists((Element)arrelem, (String)"code").booleanValue()) {
                throw new ExecutionValidationException("Provided serialization is not valid");
            }
            this.ArrayClassCode = XMLUtils.GetAttribute((Element)arrelem, (String)"code");
            List items = XMLUtils.GetChildElementsWithName((Node)arrelem, (String)"item");
            if (DataTypeUtils.CountDimentionsOfObjectArrayCode(this.ArrayClassCode) == 1) {
                this.Value = DataTypeUtils.GetArrayOfDataType(DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(this.ArrayClassCode), items.size());
                for (int i = 0; i < items.size(); ++i) {
                    Element subdtelem = XMLUtils.GetChildElementWithName((Node)((Node)items.get(i)), (String)"dt");
                    if (subdtelem == null) {
                        throw new ExecutionSerializationException("Not valid serialization provided");
                    }
                    this.Value[i] = DataTypeUtils.GetDataType(subdtelem);
                }
            } else {
                this.Value = DataTypeUtils.GetArrayOfDataType(IDataType.DataTypes.Array, items.size());
                for (int i = 0; i < items.size(); ++i) {
                    Element subdtelem = XMLUtils.GetChildElementWithName((Node)((Node)items.get(i)), (String)"dt");
                    if (subdtelem == null) {
                        throw new ExecutionSerializationException("Not valid serialization provided");
                    }
                    this.Value[i] = DataTypeUtils.GetDataType(subdtelem);
                }
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        if (this.ArrayClassCode == null || this.ArrayClassCode.trim().length() == 0) {
            throw new IllegalStateException("Array code has not been set");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<dt type=\"" + this.GetDataTypeEnum().toString() + "\">");
        if (this.DefaultConverter != null) {
            buf.append("<defConverter>" + XMLUtils.DoReplaceSpecialCharachters((String)this.DefaultConverter) + "</defConverter>");
        }
        if (this.DefaultComponentType != null) {
            buf.append("<defComponent>" + XMLUtils.DoReplaceSpecialCharachters((String)this.DefaultComponentType) + "</defComponent>");
        }
        buf.append("<value>");
        if (this.Value == null) {
            buf.append("<array code=\"" + this.GetArrayClassCode() + "\"/>");
        } else {
            buf.append("<array code=\"" + this.GetArrayClassCode() + "\">");
            for (IDataType dt : this.Value) {
                buf.append("<item>");
                buf.append(dt.ToXML());
                buf.append("</item>");
            }
            buf.append("</array>");
        }
        buf.append("</value>");
        buf.append("</dt>");
        return buf.toString();
    }
}

