/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.condition;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.condition.IConditionEnvironment;
import gr.uoa.di.madgik.execution.plan.element.condition.IConditionTreeElement;
import gr.uoa.di.madgik.execution.plan.element.condition.IPlanCondition;
import gr.uoa.di.madgik.execution.utils.ConditionUtils;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConditionTreeLeaf
implements IConditionTreeElement {
    public IPlanCondition Condition = null;

    @Override
    public boolean EvaluateCondition(ExecutionHandle Handle, IConditionEnvironment Environment) throws ExecutionRunTimeException {
        return this.Condition.EvaluateCondition(Handle, Environment);
    }

    @Override
    public void InitializeCondition() {
        this.Condition.InitializeCondition();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided serialization of condition tree leaf", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree leaf");
            }
            if (!IConditionTreeElement.TreeElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetTreeElementType())) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree leaf");
            }
            Element elem = XMLUtils.GetChildElementWithName((Node)XML, (String)"condition");
            if (elem == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree leaf");
            }
            this.Condition = ConditionUtils.GetPlanCondition(elem);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided serialization of condition tree leaf", ex);
        }
    }

    @Override
    public IConditionTreeElement.TreeElementType GetTreeElementType() {
        return IConditionTreeElement.TreeElementType.Leaf;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<treeElement type=\"" + this.GetTreeElementType().toString() + "\">");
        buf.append(this.Condition.ToXML());
        buf.append("</treeElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Condition == null) {
            throw new ExecutionValidationException("Condition tree leaf doesn't have a condition set");
        }
        this.Condition.Validate();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Condition.Validate();
        this.Condition.ValidatePreExecution(Handle);
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        return this.Condition.GetNeededVariableNames();
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        return this.Condition.GetModifiedVariableNames();
    }
}

