/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterArrayEvaluationFilter
extends ParameterFilterBase {
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;
    public List<String> FilteredVariableNames = new ArrayList<String>();

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.ArrayEvaluation;
    }

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.FilteredVariableNames);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        if (this.StoreOutputVariableName != null) {
            vars.add(this.StoreOutputVariableName);
        }
        return vars;
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableNames == null || this.FilteredVariableNames.size() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("Needed parameter is not provided");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        NamedDataType ndt;
        this.Validate();
        IDataType.DataTypes elementType = null;
        for (String s : this.FilteredVariableNames) {
            if (!Handle.GetPlan().Variables.Contains(s)) {
                throw new ExecutionValidationException("Needed parameter not found");
            }
            ndt = Handle.GetPlan().Variables.Get(s);
            if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(s)) {
                throw new ExecutionValidationException("Needed variable not available");
            }
            if (elementType == null) {
                elementType = ndt.Value.GetDataTypeEnum();
                continue;
            }
            if (elementType == ndt.Value.GetDataTypeEnum()) continue;
            throw new ExecutionValidationException("Variables to be used for array evaluation not of the same type");
        }
        if (this.StoreOutput()) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (!Handle.GetPlan().Variables.Contains(storeVarName)) {
                    throw new ExecutionValidationException("Needed parameter to store output not present");
                }
                ndt = Handle.GetPlan().Variables.Get(storeVarName);
                if (ndt.Value.GetDataTypeEnum() == IDataType.DataTypes.Array) continue;
                throw new ExecutionValidationException("Output variable is not of array type");
            }
        }
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            DataTypeArray dtOut = null;
            dtOut = new DataTypeArray();
            dtOut.SetArrayClassCode("[" + (Object)((Object)Handle.GetPlan().Variables.Get((String)this.FilteredVariableNames.get((int)0)).Value.GetDataTypeEnum()));
            int length = this.FilteredVariableNames.size();
            ArrayList<IDataType> items = new ArrayList<IDataType>();
            for (int i = 0; i < length; ++i) {
                items.add(Handle.GetPlan().Variables.Get((String)this.FilteredVariableNames.get((int)i)).Value);
            }
            dtOut.SetValue(items.toArray(new IDataType[0]));
            return dtOut.GetValue();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not extract value", ex);
        }
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredList>");
        for (String s : this.FilteredVariableNames) {
            buf.append("<filteredVariable name=\"" + s + "\"/>");
        }
        buf.append("</filteredList>");
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredList")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            List filteredvars = XMLUtils.GetChildElementsWithName((Node)tmp, (String)"filteredVariable");
            if (filteredvars == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableNames.clear();
            for (Element filtervar : filteredvars) {
                if (!XMLUtils.AttributeExists((Element)filtervar, (String)"name").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.FilteredVariableNames.add(XMLUtils.GetAttribute((Element)filtervar, (String)"name"));
            }
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }
}

