/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.utils;

import gr.uoa.di.madgik.commons.channel.proxy.ChannelLocatorFactory;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.plan.element.invocable.IExecutionContext;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSExecutionContext;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSExecutionContextConfig;
import java.net.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExecutionContextUtils {
    private static final String ExecutionContextNS = "http://context.execution.madgik.di.uoa.gr";

    public static String GenerateExecutionContextSoapHeaderElement(IChannelLocator ContextChannel, String ContextID, String ExternalSender, WSExecutionContextConfig ContextConfig) throws ExecutionSerializationException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("<execcntx:Context xmlns:execcntx=\"http://context.execution.madgik.di.uoa.gr\">");
            buf.append("<execcntx:ID>" + ContextID + "</execcntx:ID>");
            buf.append("<execcntx:Sender>" + ExternalSender + "</execcntx:Sender>");
            if (ContextChannel != null) {
                buf.append("<execcntx:Channel>" + XMLUtils.DoReplaceSpecialCharachters((String)ContextChannel.ToURI().toString()) + "</execcntx:Channel>");
            }
            if (ContextConfig != null) {
                buf.append("<execcntx:Config>" + XMLUtils.DoReplaceSpecialCharachters((String)ContextConfig.ToXML()) + "</execcntx:Config>");
            }
            buf.append("</execcntx:Context>");
            return buf.toString();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not create Soap Header element for Execution Context", ex);
        }
    }

    public static String GenerateExecutionEngineSoapHeaderElement(IChannelLocator ContextChannel, String ContextID, String ExternalSender, WSExecutionContextConfig ContextConfig) throws ExecutionSerializationException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("<execcntx:ExecutionEngineHeader xmlns:execcntx=\"http://context.execution.madgik.di.uoa.gr\">");
            buf.append(ExecutionContextUtils.GenerateExecutionContextSoapHeaderElement(ContextChannel, ContextID, ExternalSender, ContextConfig));
            buf.append("</execcntx:ExecutionEngineHeader>");
            return buf.toString();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not create Soap Header element for Execution Context", ex);
        }
    }

    public static IExecutionContext GetExecutionContext(String SOAPHeaderSerialization) throws ExecutionSerializationException {
        try {
            Element configelement;
            String ContextID = null;
            String ExternalSender = null;
            IChannelLocator Locator = null;
            WSExecutionContextConfig Config = null;
            Document doc = XMLUtils.Deserialize((String)SOAPHeaderSerialization);
            Element engroot = XMLUtils.GetChildElementWithNameAndNamespace((Node)doc.getDocumentElement(), (String)"ExecutionEngineHeader", (String)ExecutionContextNS);
            if (engroot == null || engroot.getPrefix() == null || !engroot.getPrefix().equals("execcntx")) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            if (!engroot.getLocalName().equals("ExecutionEngineHeader")) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            if (engroot.getNamespaceURI() == null || !engroot.getNamespaceURI().equals(ExecutionContextNS)) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            Element contextroot = XMLUtils.GetChildElementWithNameAndNamespace((Node)engroot, (String)"Context", (String)ExecutionContextNS);
            if (contextroot == null || contextroot.getPrefix() == null || !contextroot.getPrefix().equals("execcntx")) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            if (!contextroot.getLocalName().equals("Context")) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            if (contextroot.getNamespaceURI() == null || !contextroot.getNamespaceURI().equals(ExecutionContextNS)) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            Element idelement = XMLUtils.GetChildElementWithNameAndNamespace((Node)contextroot, (String)"ID", (String)ExecutionContextNS);
            if (idelement == null) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            ContextID = XMLUtils.GetChildText((Node)idelement);
            Element senderelement = XMLUtils.GetChildElementWithNameAndNamespace((Node)contextroot, (String)"Sender", (String)ExecutionContextNS);
            if (senderelement == null) {
                throw new ExecutionSerializationException("Not valid serialization of execution context");
            }
            ExternalSender = XMLUtils.GetChildText((Node)senderelement);
            Element channelelement = XMLUtils.GetChildElementWithNameAndNamespace((Node)contextroot, (String)"Channel", (String)ExecutionContextNS);
            if (channelelement != null) {
                String channelPayload = XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)channelelement));
                Locator = ChannelLocatorFactory.GetLocator((URI)new URI(channelPayload));
            }
            if ((configelement = XMLUtils.GetChildElementWithNameAndNamespace((Node)contextroot, (String)"Config", (String)ExecutionContextNS)) != null) {
                String configPayload = XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)configelement));
                Config = new WSExecutionContextConfig();
                Config.FromXML(configPayload);
            }
            return new WSExecutionContext(ContextID, ExternalSender, Locator, Config);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize execution context", ex);
        }
    }
}

