/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.attachment;

import gr.uoa.di.madgik.commons.utils.FileUtils;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.ss.StorageSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExecutionAttachment {
    public AttachmentLocation LocationType = AttachmentLocation.LocalFile;
    public String LocationValue = null;
    public String RestoreLocationValue = null;
    public boolean CleanUpRestored = true;
    public String Permissions = null;
    public File tmpFile = null;
    private static Logger logger = LoggerFactory.getLogger(ExecutionAttachment.class);

    public void MoveTmpToRestore(ExecutionHandle Handle) throws Exception {
        File rest = Handle.GetIsolatedFile(new File(this.RestoreLocationValue));
        if (rest.getParentFile() != null) {
            rest.getParentFile().mkdirs();
        }
        this.tmpFile.renameTo(rest);
        rest.deleteOnExit();
        if (this.Permissions != null) {
            FileUtils.MakeFilePermissions((File)rest, (String)this.Permissions);
        }
        this.tmpFile = null;
    }

    public void WriteLocalFromStorage(EnvHintCollection Hints) throws Exception {
        if (this.LocationType != AttachmentLocation.StorageSystem) {
            return;
        }
        File f = StorageSystem.Retrieve((String)this.LocationValue, (EnvHintCollection)Hints);
        f.deleteOnExit();
        this.tmpFile = File.createTempFile(UUID.randomUUID().toString(), ".attachment.tmp");
        this.tmpFile.deleteOnExit();
        f.renameTo(this.tmpFile);
        if (this.Permissions != null) {
            FileUtils.MakeFilePermissions((File)this.tmpFile, (String)this.Permissions);
            FileUtils.MakeFilePermissions((File)f, (String)this.Permissions);
        }
    }

    public void WriteLocalFromStream(DataInputStream din) throws Exception {
        try (FilterOutputStream bout = null;){
            int size;
            this.tmpFile = File.createTempFile(UUID.randomUUID().toString(), ".attachment.tmp");
            this.tmpFile.deleteOnExit();
            bout = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
            while ((size = din.readInt()) >= 0) {
                byte[] buf = new byte[size];
                din.readFully(buf);
                bout.write(buf);
            }
            ((BufferedOutputStream)bout).flush();
            bout.close();
            if (this.Permissions != null) {
                FileUtils.MakeFilePermissions((File)this.tmpFile, (String)this.Permissions);
            }
        }
    }

    public void WriteLocalToStream(DataOutputStream dout) throws IOException {
        try (BufferedInputStream bin = null;){
            byte[] buf;
            int read;
            if (this.LocationType != AttachmentLocation.LocalFile) {
                return;
            }
            bin = new BufferedInputStream(new FileInputStream(new File(this.LocationValue)));
            while ((read = bin.read(buf = new byte[4096])) >= 0) {
                dout.writeInt(read);
                dout.write(buf, 0, read);
            }
            dout.writeInt(-1);
        }
    }

    public void Validate() throws ExecutionValidationException {
        if (this.LocationValue == null || this.LocationValue.trim().length() == 0) {
            throw new ExecutionValidationException("Needed attachement location value not provided");
        }
        if (this.RestoreLocationValue == null || this.RestoreLocationValue.trim().length() == 0) {
            throw new ExecutionValidationException("Needed attachement restore location value not provided");
        }
    }

    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<attachment type=\"" + this.LocationType.toString() + "\" cleanup=\"" + this.CleanUpRestored + "\">");
        buf.append("<value>" + this.LocationValue + "</value>");
        buf.append("<restore>" + this.RestoreLocationValue + "</restore>");
        if (this.Permissions != null && this.Permissions.trim().length() != 0) {
            buf.append("<permissions value=\"" + this.Permissions + "\"/>");
        }
        buf.append("</attachment>");
        return buf.toString();
    }

    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serialization provided");
            }
            this.LocationType = AttachmentLocation.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type"));
            if (!XMLUtils.AttributeExists((Element)XML, (String)"cleanup").booleanValue()) {
                throw new ExecutionSerializationException("Invalid serialization provided");
            }
            this.CleanUpRestored = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XML, (String)"cleanup"));
            Element valueElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valueElement == null) {
                throw new ExecutionSerializationException("Invalid serialization provided");
            }
            this.LocationValue = XMLUtils.GetChildText((Node)valueElement);
            Element restoreElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"restore");
            if (restoreElement == null) {
                throw new ExecutionSerializationException("Invalid serialization provided");
            }
            this.RestoreLocationValue = XMLUtils.GetChildText((Node)restoreElement);
            Element permsElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"permissions");
            if (permsElement != null) {
                if (!XMLUtils.AttributeExists((Element)permsElement, (String)"value").booleanValue()) {
                    throw new ExecutionSerializationException("Invalid serialization provided");
                }
                this.Permissions = XMLUtils.GetAttribute((Element)permsElement, (String)"value");
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    public static enum AttachmentLocation {
        LocalFile,
        StorageSystem;

    }
}

