/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.condition;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.condition.IConditionEnvironment;
import gr.uoa.di.madgik.execution.plan.element.condition.IConditionTreeElement;
import gr.uoa.di.madgik.execution.utils.ConditionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConditionTreeNode
implements IConditionTreeElement {
    private static Logger logger = LoggerFactory.getLogger(ConditionTreeNode.class);
    public NodeVerb Verb = NodeVerb.AND;
    public PostVerb Post = PostVerb.AsIs;
    public List<IConditionTreeElement> Childen = new ArrayList<IConditionTreeElement>();

    @Override
    public void InitializeCondition() {
        for (IConditionTreeElement elem : this.Childen) {
            elem.InitializeCondition();
        }
    }

    @Override
    public boolean EvaluateCondition(ExecutionHandle Handle, IConditionEnvironment Environment) throws ExecutionRunTimeException {
        switch (this.Verb) {
            case AND: {
                switch (this.Post) {
                    case AsIs: {
                        return this.evaluateAND(Handle, Environment);
                    }
                    case Negate: {
                        return !this.evaluateAND(Handle, Environment);
                    }
                }
                throw new ExecutionRunTimeException("Unrecognized condition");
            }
            case OR: {
                switch (this.Post) {
                    case AsIs: {
                        return this.evaluateOR(Handle, Environment);
                    }
                    case Negate: {
                        return !this.evaluateOR(Handle, Environment);
                    }
                }
                throw new ExecutionRunTimeException("Unrecognized condition");
            }
        }
        throw new ExecutionRunTimeException("Unrecognized condition");
    }

    private boolean evaluateAND(ExecutionHandle Handle, IConditionEnvironment Environment) throws ExecutionRunTimeException {
        for (IConditionTreeElement elem : this.Childen) {
            boolean eval = elem.EvaluateCondition(Handle, Environment);
            logger.debug("AND subelement evaluated to " + eval);
            if (eval) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateOR(ExecutionHandle Handle, IConditionEnvironment Environment) throws ExecutionRunTimeException {
        for (IConditionTreeElement elem : this.Childen) {
            boolean eval = elem.EvaluateCondition(Handle, Environment);
            logger.debug("OR subelement evaluated to " + eval);
            if (!eval) continue;
            return true;
        }
        return false;
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided serialization of condition tree node", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            this.Childen.clear();
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree node");
            }
            if (!IConditionTreeElement.TreeElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetTreeElementType())) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree node");
            }
            if (!XMLUtils.AttributeExists((Element)XML, (String)"verb").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree node");
            }
            this.Verb = NodeVerb.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"verb"));
            if (!XMLUtils.AttributeExists((Element)XML, (String)"post").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree node");
            }
            this.Post = PostVerb.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"post"));
            List elems = XMLUtils.GetChildElementsWithName((Node)XML, (String)"treeElement");
            if (elems == null || elems.size() == 0) {
                throw new ExecutionSerializationException("Provided serialization is not a valid serialization of a condition tree node");
            }
            for (Element elem : elems) {
                this.Childen.add(ConditionUtils.GetConditionTreeElement(elem));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided serialization of condition tree leaf", ex);
        }
    }

    @Override
    public IConditionTreeElement.TreeElementType GetTreeElementType() {
        return IConditionTreeElement.TreeElementType.Node;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<treeElement type=\"" + this.GetTreeElementType().toString() + "\" verb=\"" + this.Verb.toString() + "\" post=\"" + this.Post.toString() + "\">");
        for (IConditionTreeElement child : this.Childen) {
            buf.append(child.ToXML());
        }
        buf.append("</treeElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Childen.size() == 0) {
            throw new ExecutionValidationException("Condition tree node doesn't have a condition set");
        }
        for (IConditionTreeElement child : this.Childen) {
            child.Validate();
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        for (IConditionTreeElement child : this.Childen) {
            child.ValidatePreExecution(Handle);
        }
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> inputs = new HashSet<String>();
        for (IConditionTreeElement child : this.Childen) {
            inputs.addAll(child.GetNeededVariableNames());
        }
        return inputs;
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> outputs = new HashSet<String>();
        for (IConditionTreeElement child : this.Childen) {
            outputs.addAll(child.GetModifiedVariableNames());
        }
        return outputs;
    }

    public static enum NodeVerb {
        AND,
        OR;

    }

    public static enum PostVerb {
        AsIs,
        Negate;

    }
}

