/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReflectableItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String Name = null;
    public String Token = null;
    public IDataType Value = null;

    public String ToXML() throws ExecutionSerializationException {
        if (this.Value == null) {
            throw new ExecutionSerializationException("Value cannot be null");
        }
        StringBuilder buf = new StringBuilder();
        String tokenString = "token=\"" + this.Token + "\"";
        if (this.Token == null) {
            tokenString = "";
        }
        buf.append("<item name=\"" + this.Name + "\" " + tokenString + ">");
        buf.append(this.Value.ToXML());
        buf.append("</item>");
        return buf.toString();
    }

    public void FromXML(Element element) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)element, (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Not a valid serialization of a named data type");
            }
            this.Name = XMLUtils.GetAttribute((Element)element, (String)"name");
            this.Token = XMLUtils.AttributeExists((Element)element, (String)"token") != false ? XMLUtils.GetAttribute((Element)element, (String)"token") : null;
            Element val = XMLUtils.GetChildElementWithName((Node)element, (String)"dt");
            if (val == null) {
                throw new ExecutionSerializationException("Not a valid serialization of a named data type");
            }
            this.Value = DataTypeUtils.GetDataType(val);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize named data type from provided serialization", ex);
        }
    }
}

