/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.report.accounting;

import gr.uoa.di.madgik.environment.accounting.AccountingSystem;
import gr.uoa.di.madgik.environment.accounting.properties.JobProperties;
import gr.uoa.di.madgik.environment.accounting.record.ExecutionUsageRecord;
import gr.uoa.di.madgik.environment.accounting.record.JobUsageRecord;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.report.Dispatcher;
import gr.uoa.di.madgik.execution.utils.ExecutionPlanAnalyser;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobAccountingDispatcher
extends Dispatcher {
    private Logger log = LoggerFactory.getLogger((String)JobAccountingDispatcher.class.getName());
    private ExecutionHandle handle;
    private String adaptor = null;
    private Date jobStart = null;
    private Date jobEnd = null;
    private static final String ACTIONSCOPE = "GCubeActionScope";

    public JobAccountingDispatcher(ExecutionHandle handle) {
        this.handle = handle;
        try {
            this.adaptor = Thread.currentThread().getStackTrace()[5].getClassName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jobStart = new Date();
    }

    private Date getJobStart() {
        if (this.jobStart == null) {
            this.jobStart = new Date();
        }
        return this.jobStart;
    }

    @Override
    public void run() {
        String consumerId = this.adaptor;
        Date startTime = this.getJobStart();
        Date endTime = new Date();
        String scope = null;
        if (this.handle.GetPlan().EnvHints.GetHint(ACTIONSCOPE) != null) {
            scope = this.handle.GetPlan().EnvHints.GetHint((String)ACTIONSCOPE).Hint.Payload;
        }
        String owner = null;
        try {
            owner = ExecutionEngine.getLocalhost();
        }
        catch (Exception e) {
            // empty catch block
        }
        String jobId = this.handle.GetPlan().Root.GetID();
        String jobQualifier = this.adaptor;
        Object jobName = null;
        String jobStatus = this.handle.GetHandleState().toString().toLowerCase();
        if (this.jobEnd == null && (jobStatus.equalsIgnoreCase(ExecutionHandle.HandleState.Completed.toString()) || jobStatus.equalsIgnoreCase(ExecutionHandle.HandleState.Cancel.toString()))) {
            this.jobEnd = new Date();
        }
        String jobStart = String.valueOf(this.getJobStart().getTime());
        String jobEnd = this.jobEnd == null ? null : String.valueOf(this.jobEnd.getTime());
        int numOfBound = ExecutionPlanAnalyser.countBoundaries(this.handle.GetPlan());
        String vmsUsed = numOfBound >= 0 ? String.valueOf(1 + numOfBound) : null;
        String wallDuration = jobEnd != null ? String.valueOf(this.jobEnd.getTime() - this.jobStart.getTime()) : null;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(JobProperties.jobId.toString(), jobId);
        props.put(JobProperties.jobQualifier.toString(), jobQualifier);
        props.put(JobProperties.jobName.toString(), (String)jobName);
        props.put(JobProperties.jobStatus.toString(), jobStatus);
        props.put(JobProperties.jobStart.toString(), jobStart);
        props.put(JobProperties.jobEnd.toString(), jobEnd);
        props.put(JobProperties.vmsUsed.toString(), vmsUsed);
        props.put(JobProperties.wallDuration.toString(), wallDuration);
        JobUsageRecord record = new JobUsageRecord(consumerId, startTime, endTime, scope, owner, props);
        try {
            AccountingSystem.send((ExecutionUsageRecord)record);
        }
        catch (Exception e) {
            this.log.warn("Could not send accounting record: ", (Throwable)e);
        }
    }
}

