/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IParameter;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterProcessingPlanElement
extends PlanElementBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(ParameterProcessingPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = ParameterProcessingPlanElement.class.getSimpleName();
    public List<IInputParameter> Parameters = new ArrayList<IInputParameter>();

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Filter;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Parameters == null || this.Parameters.size() == 0) {
            throw new ExecutionValidationException("Filters collection cannot be null or empty. Consider removing the Filtering element");
        }
        for (IParameter iParameter : this.Parameters) {
            iParameter.Validate();
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        Set<String> ExcludeAvailableConstraint = this.GetModifiedVariableNames();
        for (IParameter iParameter : this.Parameters) {
            iParameter.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        }
    }

    @Override
    protected Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<list>");
        for (IParameter iParameter : this.Parameters) {
            buf.append(iParameter.ToXML());
        }
        buf.append("</list>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element params = XMLUtils.GetChildElementWithName((Node)XML, (String)"list");
            if (params == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            List paramlst = XMLUtils.GetChildElementsWithName((Node)params, (String)"param");
            if (paramlst == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            for (Element par : paramlst) {
                IParameter paramIn = ParameterUtils.GetParameter(par);
                if (!(paramIn instanceof IInputParameter)) {
                    throw new ExecutionSerializationException("Provided serialization not valid");
                }
                this.Parameters.add((IInputParameter)paramIn);
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        return acts;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (IParameter iParameter : this.Parameters) {
            vars.addAll(iParameter.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (IParameter iParameter : this.Parameters) {
            vars.addAll(iParameter.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    protected void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int port = -1;
        String hostname = "Unknown";
        try {
            if (Handle.getHostingNodeInfo() != null) {
                String[] params = Handle.getHostingNodeInfo().split(":");
                hostname = params[0];
                if (params[1].compareTo("null") != 0) {
                    port = Integer.parseInt(params[1]);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error occurred!", (Throwable)e);
        }
        int TotalSteps = this.Parameters.size() + 2;
        logger.debug("Starting");
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, TotalSteps, "Starting Execution of " + this.Name, this.Name, hostname, port));
        }
        this.StopClock(PlanElementBase.ClockType.Init);
        for (int i = 0; i < this.Parameters.size(); ++i) {
            this.StartClock(PlanElementBase.ClockType.Init);
            this.CheckStatus(Handle);
            this.StopClock(PlanElementBase.ClockType.Init);
            logger.debug("Processing filtering element " + (i + 1) + " of " + this.Parameters.size());
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1 + (i + 1), TotalSteps, "Processing filtering element " + (i + 1) + " of " + this.Parameters.size(), this.Name, hostname, port));
            }
            try {
                this.StartClock(PlanElementBase.ClockType.Children);
                this.Parameters.get(i).GetParameterValue(Handle);
                this.StopClock(PlanElementBase.ClockType.Children);
                continue;
            }
            catch (Exception ex) {
                ExceptionUtils.ThrowTransformedRunTimeException(ex);
            }
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), TotalSteps, TotalSteps, "Finishing Execution of " + this.Name, this.Name, hostname, port));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }
}

