/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.variable;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputOutputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IParameter;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleInOutParameter
implements IInputOutputParameter {
    private static final long serialVersionUID = 1L;
    public String VariableName = null;

    @Override
    public Object GetParameterValue(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionValidationException {
        return Handle.GetPlan().Variables.Get((String)this.VariableName).Value.GetValue();
    }

    @Override
    public boolean CanSuggestParameterValueType(ExecutionHandle Handle) {
        return Handle.GetPlan().Variables.Get((String)this.VariableName).Value.CanSuggestDataTypeClass();
    }

    @Override
    public Class<?> SuggestParameterValueType(ExecutionHandle Handle) {
        return Handle.GetPlan().Variables.Get((String)this.VariableName).Value.GetDataTypeClass();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"direction").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"process").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IParameter.ParameterDirectionType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"direction")).equals((Object)this.GetDirectionType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IParameter.ParameterProcessType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"process")).equals((Object)this.GetProcessType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element varelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"variable");
            if (varelem == null) {
                throw new ExecutionSerializationException("provided serialization is not valid serialization of element");
            }
            if (!XMLUtils.AttributeExists((Element)varelem, (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("provided serialization is not valid serialization of element");
            }
            this.VariableName = XMLUtils.GetAttribute((Element)varelem, (String)"name");
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public IParameter.ParameterDirectionType GetDirectionType() {
        return IParameter.ParameterDirectionType.InOut;
    }

    @Override
    public IParameter.ParameterProcessType GetProcessType() {
        return IParameter.ParameterProcessType.Simple;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<param direction=\"" + this.GetDirectionType().toString() + "\" process=\"" + this.GetProcessType().toString() + "\">");
        buf.append("<variable name=\"" + this.VariableName + "\"/>");
        buf.append("</param>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.VariableName == null || this.VariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Variable name not provided");
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.VariableName)) {
            throw new ExecutionValidationException("needed variable name not found");
        }
        if (!Handle.GetPlan().Variables.Get((String)this.VariableName).IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.VariableName)) {
            throw new ExecutionValidationException("needed variable not set as available");
        }
    }

    @Override
    public void SetParameterValue(ExecutionHandle Handle, Object Value) throws ExecutionRunTimeException, ExecutionValidationException {
        Handle.GetPlan().Variables.Update(this.VariableName, Value);
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.VariableName);
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.VariableName);
        return vars;
    }
}

