/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.report.accounting;

import gr.uoa.di.madgik.environment.accounting.AccountingSystem;
import gr.uoa.di.madgik.environment.accounting.properties.TaskProperties;
import gr.uoa.di.madgik.environment.accounting.record.ExecutionUsageRecord;
import gr.uoa.di.madgik.environment.accounting.record.TaskUsageRecord;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.report.Dispatcher;
import gr.uoa.di.madgik.execution.utils.ExecutionPlanAnalyser;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAccountingDispatcher
extends Dispatcher {
    private Logger log = LoggerFactory.getLogger((String)TaskAccountingDispatcher.class.getName());
    private ExecutionHandle handle;
    private String adaptor = null;
    private String cores = null;
    private Date jobStart = null;
    private Date jobEnd = null;
    private static final String ACTIONSCOPE = "GCubeActionScope";

    public TaskAccountingDispatcher(ExecutionHandle handle) {
        this.handle = handle;
        try {
            this.adaptor = Thread.currentThread().getStackTrace()[2].getClassName();
            this.cores = String.valueOf(handle.GetActionsRunning() > 0 ? handle.GetActionsRunning() : 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jobStart = new Date();
    }

    private Date getJobStart() {
        if (this.jobStart == null) {
            this.jobStart = new Date();
        }
        return this.jobStart;
    }

    @Override
    public void run() {
        int sleepTime = 50;
        while (sleepTime < 10000 && this.handle.GetHandleState().equals((Object)ExecutionHandle.HandleState.Running)) {
            sleepTime *= 2;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
        String consumerId = this.adaptor;
        Date startTime = this.getJobStart();
        Date endTime = new Date();
        String scope = null;
        if (this.handle.GetPlan().EnvHints.GetHint(ACTIONSCOPE) != null) {
            scope = this.handle.GetPlan().EnvHints.GetHint((String)ACTIONSCOPE).Hint.Payload;
        }
        String owner = null;
        try {
            owner = ExecutionEngine.getLocalhost();
        }
        catch (Exception e) {
            // empty catch block
        }
        String jobId = this.handle.GetPlan().Root.GetID();
        String usagePhase = this.handle.GetHandleState().toString().toLowerCase();
        if (this.jobEnd == null && (usagePhase.equalsIgnoreCase(ExecutionHandle.HandleState.Completed.toString()) || usagePhase.equalsIgnoreCase(ExecutionHandle.HandleState.Cancel.toString()))) {
            this.jobEnd = new Date();
        }
        String usageStart = String.valueOf(this.getJobStart().getTime());
        String usageEnd = this.jobEnd == null ? null : String.valueOf(this.jobEnd.getTime());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TaskProperties.jobId.toString(), jobId);
        props.put(TaskProperties.refHost.toString(), owner.split(":")[0]);
        props.put(TaskProperties.refVM.toString(), owner);
        props.put(TaskProperties.domain.toString(), owner.split(":")[0]);
        props.put(TaskProperties.usageStart.toString(), usageStart);
        props.put(TaskProperties.usageEnd.toString(), usageEnd);
        props.put(TaskProperties.usagePhase.toString(), usagePhase);
        props.put(TaskProperties.inputFilesNumber.toString(), String.valueOf(ExecutionPlanAnalyser.countInputFiles(this.handle.GetPlan())));
        props.put(TaskProperties.inputFilesSize.toString(), null);
        props.put(TaskProperties.outputFilesNumber.toString(), String.valueOf(ExecutionPlanAnalyser.countOutputFiles(this.handle.GetPlan())));
        props.put(TaskProperties.outputFilesSize.toString(), null);
        props.put(TaskProperties.overallNetworkIn.toString(), null);
        props.put(TaskProperties.overallNetworkOut.toString(), null);
        props.put(TaskProperties.cores.toString(), this.cores);
        props.put(TaskProperties.processors.toString(), null);
        TaskUsageRecord record = new TaskUsageRecord(consumerId, startTime, endTime, scope, owner, props);
        try {
            AccountingSystem.send((ExecutionUsageRecord)record);
        }
        catch (Exception e) {
            this.log.warn("Could not send accounting record: ", (Throwable)e);
        }
    }
}

