/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.variable;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VariableCollection
implements Iterable<NamedDataType>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Hashtable<String, NamedDataType> Variables = new Hashtable();
    final Boolean lockMe = new Boolean(false);

    public VariableCollection() {
    }

    public VariableCollection(String XML) throws ExecutionSerializationException {
        this.FromXML(XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Add(NamedDataType item) {
        Boolean bl = this.lockMe;
        synchronized (bl) {
            this.Variables.put(item.Name, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Update(String name, Object value) throws ExecutionValidationException {
        Boolean bl = this.lockMe;
        synchronized (bl) {
            NamedDataType exist = this.Variables.get(name);
            if (exist == null) {
                return;
            }
            exist.Value.SetValue(value);
            exist.IsAvailable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedDataType Get(String name) {
        Boolean bl = this.lockMe;
        synchronized (bl) {
            return this.Variables.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Contains(String name) {
        Boolean bl = this.lockMe;
        synchronized (bl) {
            return this.Variables.containsKey(name);
        }
    }

    @Override
    public Iterator<NamedDataType> iterator() {
        return this.Variables.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableCollection Subset(Set<String> NeededVars) {
        VariableCollection newCol = new VariableCollection();
        Boolean bl = this.lockMe;
        synchronized (bl) {
            for (String setName : NeededVars) {
                if (!this.Variables.containsKey(setName)) continue;
                newCol.Add(this.Variables.get(setName));
            }
        }
        return newCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Update(VariableCollection UpdateCollection, Set<String> UpdateSubset) throws ExecutionValidationException, ExecutionSerializationException {
        Boolean bl = this.lockMe;
        synchronized (bl) {
            for (String ShouldUpdate : UpdateSubset) {
                if (!UpdateCollection.Contains(ShouldUpdate) || !this.Variables.containsKey(ShouldUpdate)) continue;
                this.Update(UpdateCollection.Get(ShouldUpdate));
            }
        }
    }

    private void Update(NamedDataType item) throws ExecutionValidationException, ExecutionSerializationException {
        NamedDataType exist = this.Variables.get(item.Name);
        if (exist == null) {
            return;
        }
        exist.IsAvailable = item.IsAvailable;
        exist.Value.SetStringValue(item.Value.GetStringValue());
    }

    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<variables>");
        for (NamedDataType item : this.Variables.values()) {
            buf.append(item.ToXML());
        }
        buf.append("</variables>");
        return buf.toString();
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        this.Variables.clear();
        List variables = null;
        try {
            variables = XMLUtils.GetChildElementsWithName((Node)XML, (String)"ndt");
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not retrieve variable named data types", ex);
        }
        for (Element var : variables) {
            NamedDataType ndt = new NamedDataType();
            ndt.FromXML(var);
            this.Add(ndt);
        }
    }

    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }
}

