package gr.uoa.di.madgik.environment.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.infra.NodeInfo2HostingNodeAdapter;
import gr.uoa.di.madgik.environment.is.IInformationSystemProvider;
import gr.uoa.di.madgik.environment.is.elements.InvocablePlotInfo;
import gr.uoa.di.madgik.environment.is.elements.InvocableProfileInfo;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.environment.is.elements.matching.MatchParser;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.environment.is.Query;

public class FTPInformationSystemProvider implements IInformationSystemProvider
{
	
	private static final Object lockMe=new Object(); 
	private static Random randGen=new Random();

	public static final String FTPURLHintName="InformationSystemFTPURL";
	public static final String NodeSelectorHintName="NodeSelector";
	private static final String DefaultFTPURL="ftp://ftpuser:za73ba97ra@dl13.di.uoa.gr/d5s/is/";

	private Hashtable<String, NodeInfo> Nodes=new Hashtable<String, NodeInfo>();
	//private Hashtable<String, BoundaryListenerInfo> Boundaries=new Hashtable<String, BoundaryListenerInfo>();
	private Hashtable<String, InvocableProfileInfo> Invocables=new Hashtable<String, InvocableProfileInfo>();
	private Hashtable<String, Set<String>> InvocablesInNode=new Hashtable<String, Set<String>>();
	private Hashtable<String, Set<InvocablePlotInfo>> PlotsOfInvocable=new Hashtable<String, Set<InvocablePlotInfo>>();
	
	private URL GetFTPURL(String path, EnvHintCollection Hints) throws MalformedURLException
	{
		System.out.println("FTP url" + Hints); // XXX remove this
		if(Hints==null || !Hints.HintExists(FTPInformationSystemProvider.FTPURLHintName))
			return new URL(FTPInformationSystemProvider.DefaultFTPURL+path+".is.tmp");
		String loc=Hints.GetHint(FTPInformationSystemProvider.FTPURLHintName).Hint.Payload;
		if(loc==null || loc.trim().length()==0) return new URL(FTPInformationSystemProvider.DefaultFTPURL+path+".is.tmp");
		if(!loc.endsWith("/")) loc+="/";
		return new URL(loc+path+".is.tmp");
	}

	private static NodeSelector GetNodeSelector(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		if(Hints==null) return null;
		if(!Hints.HintExists(FTPInformationSystemProvider.NodeSelectorHintName)) return InformationSystem.GetDefaultNodeSelector();
		String nodeSelectorClassName =  Hints.GetHint(FTPInformationSystemProvider.NodeSelectorHintName).Hint.Payload;
		try { return (NodeSelector)Class.forName(nodeSelectorClassName).newInstance(); }
		catch(Exception e) { throw new EnvironmentInformationSystemException("Could not construct node selector", e); }
	}
	
	private void PutRemote(String path, Object obj, EnvHintCollection Hints) throws MalformedURLException, IOException
	{
		System.out.println(this.GetFTPURL(path, Hints));
		URLConnection con = this.GetFTPURL(path, Hints).openConnection();
		ObjectOutputStream oout=new ObjectOutputStream(new BufferedOutputStream(con.getOutputStream()));
		oout.writeObject(obj);
		oout.flush();
		oout.close();
	}
	
	private Object GetRemote(String path, EnvHintCollection Hints) throws MalformedURLException, IOException, ClassNotFoundException
	{
		try
		{
			System.out.println(this.GetFTPURL(path, Hints));
			URLConnection con = this.GetFTPURL(path, Hints).openConnection();
			ObjectInputStream oin=new ObjectInputStream(new BufferedInputStream(con.getInputStream()));
			Object o =oin.readObject();
			if(o == null) return null;
			return o;
		}catch(FileNotFoundException ex)
		{
			return null;
		}
	}
	
	private void FlushPlotsOfInvocable(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			this.PutRemote("PlotsOfInvocable", this.PlotsOfInvocable,Hints);
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
	private void FlushInvocablesInNode(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			this.PutRemote("InvocablesInNode", this.InvocablesInNode,Hints);
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
	private void FlushInvocables(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			this.PutRemote("Invocables", this.Invocables,Hints);
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
//	private void FlushBoundaries(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		try
//		{
//			this.PutRemote("Boundaries", this.Boundaries,Hints);
//		}catch(Exception ex)
//		{
//			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
//		}
//	}
	
	private void FlushNodes(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			this.PutRemote("Nodes", this.Nodes,Hints);
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void GetPlotsOfInvocable(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			Object objs=this.GetRemote("PlotsOfInvocable",Hints);
			if(objs==null) this.PlotsOfInvocable.clear();
			else this.PlotsOfInvocable=(Hashtable<String, Set<InvocablePlotInfo>>)objs;
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void GetInvocablesInNode(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			Object objs=this.GetRemote("InvocablesInNode",Hints);
			if(objs==null) this.InvocablesInNode.clear();
			else this.InvocablesInNode=(Hashtable<String, Set<String>>)objs;
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void GetInvocables(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			Object objs=this.GetRemote("Invocables",Hints);
			if(objs==null) this.Invocables.clear();
			else this.Invocables=(Hashtable<String, InvocableProfileInfo>)objs;
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
//	@SuppressWarnings("unchecked")
//	private void GetBoundaries(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		try
//		{
//			Object objs=this.GetRemote("Boundaries",Hints);
//			if(objs==null) this.Boundaries.clear();
//			else this.Boundaries=(Hashtable<String, BoundaryListenerInfo>)objs;
//		}catch(Exception ex)
//		{
//			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
//		}
//	}
	
	@SuppressWarnings("unchecked")
	private void GetNodes(EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		try
		{
			Object objs=this.GetRemote("Nodes",Hints);
			if(objs==null) this.Nodes.clear();
			else this.Nodes=(Hashtable<String, NodeInfo>)objs;
		}catch(Exception ex)
		{
			throw new EnvironmentInformationSystemException("Could not retrieve needed info", ex);
		}
	}
	
	public List<String> RetrieveByQualifier(String qualifier,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		throw new EnvironmentInformationSystemException("Unsupported action");
	}

	public List<String> Query(Query query,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		return new ArrayList<String>();
	}
	
	public List<String> Query(String queryString, EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		return new ArrayList<String>();
	}
	
	public String RegisterNode(NodeInfo info,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			if(info.ID==null) throw new EnvironmentInformationSystemException("ID not provided");
			this.GetNodes(Hints);
			this.Nodes.put(info.ID, info);
			this.FlushNodes(Hints);
			return info.ID;
		}
	}
	
//	public String RegisterBoundaryListener(BoundaryListenerInfo info,EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			if(info.ID==null) throw new EnvironmentInformationSystemException("ID not provided");
//			this.GetNodes(Hints);
//			this.GetBoundaries(Hints);
//			if(!this.Nodes.containsKey(info.NodeID)) throw new EnvironmentInformationSystemException("Node id "+info.NodeID+" referenced not porovided");
//			this.Boundaries.put(info.ID, info);
//			this.FlushBoundaries(Hints);
//			return info.ID;
//		}
//	}
	
	public void RegisterInvocableInstance(String NodeID, String InvocableID,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			if(NodeID==null || InvocableID==null) throw new EnvironmentInformationSystemException("ID not provided");
			this.GetNodes(Hints);
			this.GetInvocables(Hints);
			this.GetInvocablesInNode(Hints);
			if(!this.Nodes.containsKey(NodeID)) throw new EnvironmentInformationSystemException("Node id "+NodeID+" referenced not porovided");
			if(!this.Invocables.containsKey(InvocableID)) throw new EnvironmentInformationSystemException("Invocable id "+InvocableID+" referenced not porovided");
			if(!this.InvocablesInNode.contains(NodeID)) this.InvocablesInNode.put(NodeID, new HashSet<String>());
			this.InvocablesInNode.get(NodeID).add(InvocableID);
			this.FlushInvocablesInNode(Hints);
		}
	}
	
	public String RegisterInvocable(InvocableProfileInfo info,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized (FTPInformationSystemProvider.lockMe)
		{
			if(info.ID==null) throw new EnvironmentInformationSystemException("ID not provided");
			this.GetInvocables(Hints);
			this.Invocables.put(info.ID, info);
			this.FlushInvocables(Hints);
			return info.ID;
		}
	}
	
	public void RegisterPlotOfInvocable(String InvocableID, InvocablePlotInfo info,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			if(InvocableID==null) throw new EnvironmentInformationSystemException("ID not provided");
			this.GetInvocables(Hints);
			this.GetPlotsOfInvocable(Hints);
			if(!this.Invocables.containsKey(InvocableID)) throw new EnvironmentInformationSystemException("Invocable id "+InvocableID+" referenced not porovided");
			if(!this.PlotsOfInvocable.contains(InvocableID)) this.PlotsOfInvocable.put(InvocableID, new HashSet<InvocablePlotInfo>());
			this.PlotsOfInvocable.get(InvocableID).add(info);
			this.FlushPlotsOfInvocable(Hints);
		}
	}
	
//	public BoundaryListenerInfo GetBoundaryListenerInNode(String NodeID,EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			if(NodeID==null) throw new EnvironmentInformationSystemException("ID not provided");
//			this.GetBoundaries(Hints);
//			for(Map.Entry<String, BoundaryListenerInfo> entry : this.Boundaries.entrySet())
//			{
//				if(entry.getValue().NodeID.equals(NodeID)) return entry.getValue();
//			}
//			return null;
//		}
//	}
	
	public NodeInfo GetNode(String NodeID,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			if(NodeID==null) throw new EnvironmentInformationSystemException("ID not provided");
			this.GetNodes(Hints);
			if(!this.Nodes.containsKey(NodeID)) return null;
			return this.Nodes.get(NodeID);
		}
	}
	
	@Override 
	public List<NodeInfo> GetMatchingNodes(String RankingExpression, String RequirementsExpression, EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			try
			{
				return CollectNodeInfo(Hints, RequirementsExpression, RankingExpression);
			}catch(Exception ex)
			{
				throw new EnvironmentInformationSystemException("Could not complete information system interaction", ex);
			}
		}
	}
	
	@Override
	public NodeInfo GetMatchingNode(String RankingExpression, String RequirementsExpression,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		return GetMatchingNode(RankingExpression, RequirementsExpression, GetNodeSelector(Hints), Hints);
	}
	
	@Override
	public NodeInfo GetMatchingNode(String RankingExpression, String RequirementsExpression, NodeSelector selector, EnvHintCollection Hints) throws EnvironmentInformationSystemException 
	{
		this.GetNodes(Hints);
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			try
			{	
				List<NodeInfo> res = CollectNodeInfo(Hints, RequirementsExpression, RankingExpression);
				HostingNode hn = selector.selectNode(new NodeInfo2HostingNodeAdapter().adaptAll(res));
				for(NodeInfo ni : res)
				{
					if(ni.ID.equals(hn.getId())) return ni;
				}
				return null;
			}catch(Exception ex)
			{
				throw new EnvironmentInformationSystemException("Could not complete information system interaction",ex);
			}
		}
	}
	
	private List<NodeInfo> CollectNodeInfo(EnvHintCollection Hints,String Requirments, String Rank) throws Exception
	{
		List<NodeInfo> nodes=new ArrayList<NodeInfo>(this.Nodes.values());
		List<NodeInfo> pickedNodes = new ArrayList<NodeInfo>();
		MatchParser parser=new MatchParser(Requirments);
		for(NodeInfo nfo : nodes)
		{
			boolean match=true;
			for(Map.Entry<String, String> entry : parser.requirments.entrySet())
			{
				if(entry.getKey()==null) break;
				if(entry.getValue()==null) break;
				String value=nfo.getExtension(entry.getKey());
				if((value==null) || (!value.trim().equalsIgnoreCase(entry.getValue().trim())))
				{
					match=false;
					break;
				}
			}
			if(match) pickedNodes.add(nfo);
		}
		return pickedNodes;
	}
	
	public InvocableProfileInfo GetInvocableProfile(String InvocableProfileID,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			if(InvocableProfileID==null) throw new EnvironmentInformationSystemException("ID not provided");
			this.GetInvocables(Hints);
			if(!this.Invocables.containsKey(InvocableProfileID)) return null;
			return this.Invocables.get(InvocableProfileID);
		}
	}
	
//	public BoundaryListenerInfo GetBoundaryListener(String ListenerID,EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			if(ListenerID==null) throw new EnvironmentInformationSystemException("ID not provided");
//			this.GetBoundaries(Hints);
//			if(!this.Boundaries.containsKey(ListenerID)) return null;
//			return this.Boundaries.get(ListenerID);
//		}
//	}
	
//	public BoundaryListenerInfo GetRandomBoundaryListener(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			this.GetBoundaries(Hints);
//			return this.Boundaries.values().toArray(new BoundaryListenerInfo[0])[randGen.nextInt(this.Boundaries.size())];
//		}
//	}
	
//	public NodeInfo GetRandomGCubeNodeContainingListener(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			this.GetNodes(Hints);
//			this.GetBoundaries(Hints);
//			List<BoundaryListenerInfo> bs=new ArrayList<BoundaryListenerInfo>();
//			for(NodeInfo nfo : this.Nodes.values())
//			{
//				if(nfo.TypeOfNode.equals(NodeInfo.NodeType.GCube))
//				{
//					for(BoundaryListenerInfo b : this.Boundaries.values())
//					{
//						if(b.NodeID.equals(nfo.ID)) bs.add(b);
//					}
//				}
//			}
//			if(bs.size()==0) return null;
//			return this.Nodes.get(bs.get(randGen.nextInt(bs.size())).NodeID);
//		}
//	}
//	
//	public NodeInfo GetRandomGridUINodeContainingListener(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			this.GetNodes(Hints);
//			this.GetBoundaries(Hints);
//			List<BoundaryListenerInfo> bs=new ArrayList<BoundaryListenerInfo>();
//			for(NodeInfo nfo : this.Nodes.values())
//			{
//				if(nfo.TypeOfNode.equals(NodeInfo.NodeType.Grid))
//				{
//					for(BoundaryListenerInfo b : this.Boundaries.values())
//					{
//						if(b.NodeID.equals(nfo.ID)) bs.add(b);
//					}
//				}
//			}
//			if(bs.size()==0) return null;
//			return this.Nodes.get(bs.get(randGen.nextInt(bs.size())).NodeID);
//		}
//	}
	
//	public NodeInfo GetRandomCondorUINodeContainingListener(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			this.GetNodes(Hints);
//			this.GetBoundaries(Hints);
//			List<BoundaryListenerInfo> bs=new ArrayList<BoundaryListenerInfo>();
//			for(NodeInfo nfo : this.Nodes.values())
//			{
//				if(nfo.TypeOfNode.equals(NodeInfo.NodeType.Condor))
//				{
//					for(BoundaryListenerInfo b : this.Boundaries.values())
//					{
//						if(b.NodeID.equals(nfo.ID)) bs.add(b);
//					}
//				}
//			}
//			if(bs.size()==0) return null;
//			return this.Nodes.get(bs.get(randGen.nextInt(bs.size())).NodeID);
//		}
//	}
	
//	public NodeInfo GetRandomHadoopUINodeContainingListener(EnvHintCollection Hints) throws EnvironmentInformationSystemException
//	{
//		synchronized(FTPInformationSystemProvider.lockMe)
//		{
//			this.GetNodes(Hints);
//			this.GetBoundaries(Hints);
//			List<BoundaryListenerInfo> bs=new ArrayList<BoundaryListenerInfo>();
//			for(NodeInfo nfo : this.Nodes.values())
//			{
//				if(nfo.TypeOfNode.equals(NodeInfo.NodeType.Hadoop))
//				{
//					for(BoundaryListenerInfo b : this.Boundaries.values())
//					{
//						if(b.NodeID.equals(nfo.ID)) bs.add(b);
//					}
//				}
//			}
//			if(bs.size()==0) return null;
//			return this.Nodes.get(bs.get(randGen.nextInt(bs.size())).NodeID);
//		}
//	}
	
	public InvocablePlotInfo GetPlotWithName(String PlotName,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			this.GetPlotsOfInvocable(Hints);
			for(Set<InvocablePlotInfo> ps : this.PlotsOfInvocable.values())
			{
				if(ps.size()==0) continue;
				for(InvocablePlotInfo p : ps)
				{
					if(p.Name.equals(PlotName)) return p;
				}
			}
			return null;
		}
	}
	
	public String GetNodeHostingInvocable(String InvocableID,EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		synchronized(FTPInformationSystemProvider.lockMe)
		{
			this.GetInvocablesInNode(Hints);
			for(Map.Entry<String, Set<String>> invocs : this.InvocablesInNode.entrySet())
			{
				for(String s : invocs.getValue())
				{
					if(s.equals(InvocableID)) return invocs.getKey();
				}
			}
		}
		return null;
	}

	public String GetGenericByID(String ID, EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		throw new EnvironmentInformationSystemException("Method not supported");
	}

	public List<String> GetGenericByName(String Name, EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		throw new EnvironmentInformationSystemException("Method not supported");
	}

	public String GetOpenSearchGenericByDescriptionDocumentURI(String URI, EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		throw new EnvironmentInformationSystemException("Method not supported");
	}
	
	public String CreateGenericResource(String genericContent, EnvHintCollection Hints) throws EnvironmentInformationSystemException
	{
		throw new EnvironmentInformationSystemException("Method not supported");
	}

	@Override
	public void UnregisterNode(String NodeID, EnvHintCollection Hints)
			throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
		
	}

	@Override
	public NodeInfo GetNode(String Hostname, String Port,
			EnvHintCollection Hints)
			throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
	}

	@Override
	public void UpdateGenericResource(String id, String content,
			gr.uoa.di.madgik.environment.is.Query query, EnvHintCollection Hints)
			throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
		
	}

	@Override
	public String CreateGenericResource(String content,
			gr.uoa.di.madgik.environment.is.Query attributes,
			EnvHintCollection Hints)
			throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
	}

	@Override
	public void DeleteGenericResource(String id, EnvHintCollection Hints)
			throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
		
	}

	// XXX
	@Override
	public String GetLocalNodeHostName() throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
	}

	@Override
	public String GetLocalNodePort() throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
	}

	@Override
	public String GetLocalNodePE2ngPort(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
		throw new EnvironmentInformationSystemException("Unimplemented method");
	}
}
