/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.gcube;

import gr.uoa.di.madgik.environment.accounting.IAccountingFrameworkProvider;
import gr.uoa.di.madgik.environment.accounting.record.ExecutionUsageRecord;
import java.util.HashMap;
import java.util.Map;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeAccountingFrameworkProvider
implements IAccountingFrameworkProvider {
    private static Logger logger = LoggerFactory.getLogger(GCubeAccountingFrameworkProvider.class);
    private static ResourceAccounting accounting = null;

    public void SessionInit() throws Exception {
        try {
            accounting = ResourceAccountingFactory.getResourceAccountingInstance();
        }
        catch (Exception e) {
            logger.warn("Could not initialise accounting propeprly", (Throwable)e);
        }
    }

    public void Send(ExecutionUsageRecord record) throws Exception {
        if (accounting == null) {
            logger.warn("Accounting not initialized");
            return;
        }
        RawUsageRecord ur = new RawUsageRecord();
        ur.setId(record.getId());
        ur.setConsumerId(record.getConsumerId());
        ur.setCreateTime(record.getCreateTime());
        ur.setStartTime(record.getStartTime());
        ur.setEndTime(record.getEndTime());
        ur.setResourceType(record.getResourceType());
        ur.setResourceScope(record.getResourceScope());
        ur.setResourceOwner(record.getResourceOwner());
        HashMap props = new HashMap();
        for (Map.Entry prop : record.getResourceProperties().entrySet()) {
            if (prop.getValue() != null) {
                props.put(prop.getKey(), prop.getValue());
                continue;
            }
            logger.debug("Going to remove accounting propery " + (String)prop.getKey() + " with null value. Usage record: " + ur);
        }
        ur.setResourceSpecificProperties(props);
        logger.debug("Sending accounting message: " + ur);
        if (ur.getResourceScope() == null) {
            logger.warn("Scope is not specified");
            return;
        }
        ScopeProvider.instance.set(ur.getResourceScope());
        accounting.sendAccountingMessage(ur);
    }
}

