/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreReader;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPStoreConnectionHandler
implements ITCPConnectionManagerEntry {
    private static Logger logger = Logger.getLogger(TCPStoreConnectionHandler.class.getName());

    public ITCPConnectionManagerEntry.NamedEntry GetName() {
        return ITCPConnectionManagerEntry.NamedEntry.gRS2Store;
    }

    public void HandleConnection(Socket socket) {
        DataInputStream in;
        DataOutputStream out;
        block11: {
            String key = null;
            out = null;
            in = null;
            try {
                in = new DataInputStream(socket.getInputStream());
                out = new DataOutputStream(socket.getOutputStream());
                key = in.readUTF();
                IBufferStore store = GRSRegistry.Registry.getStore(key);
                if (store != null) {
                    TCPWriterProxy newProxy = new TCPWriterProxy();
                    BufferStoreReader storeReader = new BufferStoreReader(key, newProxy);
                    URI storeAccessLocator = storeReader.populate();
                    out.writeUTF(storeAccessLocator.toString());
                    out.flush();
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block11;
                logger.log(Level.WARNING, "Could not handle incoming mirroring request for key " + key, ex);
            }
        }
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

