/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.Record;
import java.util.Iterator;

public class ForwardReaderIterator<T extends Record>
implements Iterator<T> {
    private ForwardReader<T> reader = null;

    protected ForwardReaderIterator(ForwardReader<T> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader.getStatus() == IBuffer.Status.Dispose || this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                return false;
            }
            if (this.reader.availableRecords() == 0) {
                return this.reader.waitAvailable(this.reader.getIteratorTimeout(), this.reader.getIteratorTimeUnit());
            }
            return true;
        }
        catch (GRS2ReaderException e) {
            return false;
        }
    }

    @Override
    public T next() {
        try {
            return this.reader.get(this.reader.getIteratorTimeout(), this.reader.getIteratorTimeUnit());
        }
        catch (GRS2ReaderException e) {
            return null;
        }
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not supported");
    }
}

