/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordMediationException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.IPumpable;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.mediation.MediatingInputStream;
import gr.uoa.di.madgik.grs.record.field.mediation.MediationFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public abstract class Field
implements IPumpable {
    protected Record record;
    private int definitionIndex = -1;
    private boolean remoteCopy = false;

    public void setDefinitionIndex(int index) {
        this.definitionIndex = index;
    }

    public int getDefinitionIndex() {
        return this.definitionIndex;
    }

    public void bind(Record record) {
        this.record = record;
    }

    public void prebind(Record record) {
        this.record = record;
    }

    public void setRemoteCopy(boolean remoteCopy) {
        this.remoteCopy = remoteCopy;
    }

    public boolean isRemoteCopy() {
        return this.remoteCopy;
    }

    public FieldDefinition getFieldDefinition() throws GRS2RecordDefinitionException {
        try {
            if (this.record == null) {
                throw new GRS2RecordDefinitionException("Field not properly bind to buffer");
            }
            if (this.definitionIndex < 0 || this.definitionIndex >= this.record.getDefinition().getDefinitionSize()) {
                throw new GRS2RecordDefinitionException("No definition found for index " + this.definitionIndex);
            }
            return this.record.getDefinition().getDefinition(this.definitionIndex);
        }
        catch (GRS2BufferException e) {
            throw new GRS2RecordDefinitionException("unable to retrieve field's definition", e);
        }
    }

    public IBuffer.TransportDirective resolveTransportDirective() throws GRS2RecordDefinitionException, GRS2BufferException {
        FieldDefinition def = this.getFieldDefinition();
        switch (def.getTransportDirective()) {
            case Full: 
            case Partial: {
                return def.getTransportDirective();
            }
            case Inherit: {
                return this.record.resolveTransportDirective();
            }
        }
        return IBuffer.TransportDirective.Full;
    }

    @Override
    public final void deflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeBoolean(this.remoteCopy);
            this.extendDeflate(out);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void send(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeInt(this.definitionIndex);
            out.writeBoolean(this.remoteCopy);
            this.extendSend(out, IBuffer.TransportOverride.Defined);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to marshal record", e);
        }
    }

    public final void makeLocal() {
        this.extendMakeLocal();
        this.remoteCopy = false;
    }

    public abstract void extendDeflate(DataOutput var1) throws GRS2RecordSerializationException;

    public abstract void extendSend(DataOutput var1, IBuffer.TransportOverride var2) throws GRS2RecordSerializationException;

    protected abstract void extendMakeLocal();

    @Override
    public final void inflate(DataInput in) throws GRS2RecordSerializationException {
        this.inflate(in, false);
    }

    @Override
    public final void inflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.remoteCopy = in.readBoolean();
            if (reset) {
                this.remoteCopy = false;
            }
            this.extendInflate(in, reset);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to unmarshal record", e);
        }
    }

    public final void receive(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.definitionIndex = in.readInt();
            this.remoteCopy = in.readBoolean();
            this.extendReceive(in, IBuffer.TransportOverride.Defined);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("unable to unmarshal record", e);
        }
    }

    public abstract void extendInflate(DataInput var1, boolean var2) throws GRS2RecordSerializationException;

    public abstract void extendReceive(DataInput var1, IBuffer.TransportOverride var2) throws GRS2RecordSerializationException;

    public void dispose() {
        this.extendDispose();
        this.record = null;
        this.definitionIndex = -1;
    }

    public abstract void extendDispose();

    public abstract boolean isAvailable();

    public void makeAvailable() throws GRS2RecordDefinitionException, GRS2BufferException, GRS2ProxyMirrorException {
        this.makeAvailable(IBuffer.TransportOverride.Override);
    }

    public void makeAvailable(IBuffer.TransportOverride override) throws GRS2RecordDefinitionException, GRS2BufferException, GRS2ProxyMirrorException {
        if (this.isAvailable()) {
            return;
        }
        IBuffer.TransportDirective dir = this.resolveTransportDirective();
        if (dir == IBuffer.TransportDirective.Full) {
            return;
        }
        if (dir == IBuffer.TransportDirective.Inherit) {
            throw new GRS2ProxyMirrorProtocolErrorException("Unsupported transport directive after resolution");
        }
        this.record.requestPartial(override, this.getDefinitionIndex());
    }

    public abstract InputStream getInputStream() throws IOException;

    public MediatingInputStream getMediatingInputStream() throws IOException, GRS2RecordMediationException {
        return MediationFactory.getStream(this);
    }
}

