/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.test;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.URLField;
import gr.uoa.di.madgik.grs.record.field.URLFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class WriterURLThread
extends Thread {
    public RecordWriter<GenericRecord> writer = null;
    private int itemsToProduce;
    private int disposePrematurely;
    private long timeoutLifecycle;
    private TimeUnit timeunitLifecycle;
    private IWriterProxy proxy = null;
    private int capacity = 0;
    private String url;
    private String additionalString;

    public WriterURLThread(IWriterProxy proxy, int itemsToProduce, int disposePrematurely, long timeoutLifecycle, TimeUnit timeunitLifecycle, int capacity, String url) {
        this.itemsToProduce = itemsToProduce;
        this.disposePrematurely = disposePrematurely;
        this.timeoutLifecycle = timeoutLifecycle;
        this.timeunitLifecycle = timeunitLifecycle;
        this.proxy = proxy;
        this.capacity = capacity;
        this.url = url;
    }

    public WriterURLThread(IWriterProxy proxy, int itemsToProduce, int disposePrematurely, long timeoutLifecycle, TimeUnit timeunitLifecycle, int capacity, String url, String additionalString) {
        this(proxy, itemsToProduce, disposePrematurely, timeoutLifecycle, timeunitLifecycle, capacity, url);
        this.additionalString = additionalString;
    }

    public void prepare() {
        try {
            System.out.println("preparing writer");
            RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new URLFieldDefinition("ThisIsTheField")})};
            this.writer = new RecordWriter(this.proxy, defs, this.capacity, RecordWriter.DefaultConcurrentPartialCapacity, 0.5f, this.timeoutLifecycle, this.timeunitLifecycle);
            System.out.println("done preparing writer");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            int count = 0;
            for (int i = 0; i < this.itemsToProduce; ++i) {
                if (i == this.disposePrematurely) {
                    System.out.println("writer disposing");
                    this.writer.dispose();
                    return;
                }
                if (this.writer.getStatus() != IBuffer.Status.Open) break;
                GenericRecord rec = new GenericRecord();
                rec.setFields(new Field[]{new URLField(new URL(this.url + (this.additionalString != null ? "|" + this.additionalString : "")))});
                if (!this.writer.put(rec, 60L, TimeUnit.SECONDS)) continue;
                ++count;
            }
            System.out.println("writen total " + count);
            System.out.println("writer closing");
            if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                this.writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

