/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.utils;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import java.net.URI;

public class Locators {
    private Locators() {
    }

    public static URI localToTCP(URI locator) throws GRS2ProxyInvalidArgumentException, GRS2ProxyInvalidOperationException {
        if (locator == null) {
            throw new GRS2ProxyInvalidArgumentException("Locator cannot be null");
        }
        if (!LocalWriterProxy.isOfType(locator)) {
            throw new GRS2ProxyInvalidArgumentException("Locator is not of appropriate type " + locator.toString());
        }
        if (locator.getQuery() == null) {
            throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
        }
        String[] qs = locator.getQuery().trim().split("=");
        if (qs.length != 2) {
            throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
        }
        if (qs[1].trim().length() == 0) {
            throw new GRS2ProxyInvalidArgumentException("Invalid key in locator " + locator.toString());
        }
        String key = qs[1];
        IBuffer buffer = GRSRegistry.Registry.getBuffer(key);
        TCPWriterProxy proxy = new TCPWriterProxy();
        proxy.setKey(key);
        buffer.setMirror(proxy.bind());
        return proxy.getLocator();
    }
}

