/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLHelper {
    private static Logger logger = Logger.getLogger(XMLHelper.class.getName());
    static DocumentBuilderFactory factory = null;
    static TransformerFactory transformerFactory = null;

    public static Document getXMLDocument(InputStream in) throws Exception {
        int b;
        StringBuffer stfBuf = new StringBuffer();
        while ((b = in.read()) != -1) {
            stfBuf.append((char)b);
        }
        logger.log(Level.FINEST, "XML read " + stfBuf.length() + " : " + stfBuf);
        ByteArrayInputStream tempStream = new ByteArrayInputStream(stfBuf.toString().getBytes());
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(tempStream);
        return doc;
    }

    public static Node getXMLNode(String str) throws Exception {
        logger.log(Level.FINEST, "XML read " + str);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(str)));
        return doc.getFirstChild();
    }

    public static Document getXMLDocument(String request) throws Exception {
        ByteArrayInputStream tempStream = new ByteArrayInputStream(request.getBytes());
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(tempStream);
        return doc;
    }

    public static void printXML(Document doc) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        System.out.println("XML OUT ----------------------------");
        StreamResult result_out = new StreamResult(System.out);
        transformer.transform(source, result_out);
        System.out.println("\nXML OUT ----------------------------");
    }

    public static void printXMLElement(Element element, OutputStream out) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(element);
        source.setNode(element);
        StreamResult result_out = new StreamResult(out);
        transformer.transform(source, result_out);
    }

    public static void printXMLNode(Node node, OutputStream out) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(node);
        source.setNode(node);
        StreamResult result_out = new StreamResult(out);
        transformer.transform(source, result_out);
    }

    public static void sendXML(Document doc, OutputStream out) throws Exception {
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        try {
            transformer.transform(source, result);
        }
        catch (Exception e) {
            XMLHelper.printXML(doc);
            throw new Exception("xml error", e);
        }
        out.flush();
    }

    static {
        transformerFactory = TransformerFactory.newInstance();
        factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(true);
    }
}

