/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.local;

import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreFactory;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

public class LocalStoreWriterProxy
implements IProxy {
    public static URI store(URI[] locators, IBufferStore.MultiplexType multiplex, long timeout, TimeUnit unit) throws GRS2BufferStoreException, GRS2ProxyInvalidArgumentException {
        IBufferStore store = null;
        try {
            store = BufferStoreFactory.getManager();
            store.setLocators(locators);
            store.setMultiplexType(multiplex);
            store.setReaderTimeout(timeout);
            store.setReaderTimeoutTimeUnit(unit);
            store.initialize();
            store.store();
            String key = GRSRegistry.Registry.add(store);
            store.setKey(key);
            return new URI("grs2-store-proxy", null, "localhost", -1, null, "key=" + key, IProxy.ProxyType.LocalStore.toString());
        }
        catch (GRS2BufferStoreException ex) {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ex;
        }
        catch (URISyntaxException exx) {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidArgumentException("Could not create store uri", exx);
        }
    }
}

