/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp.mirror;

import gr.uoa.di.madgik.compressedstream.CompressedObjectStream;
import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.BufferConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.PartialRequest;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.Request;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPWriterMirror
extends Thread
implements IMirror {
    private static Logger logger = Logger.getLogger(TCPWriterMirror.class.getName());
    private Socket socket = null;
    private String key = null;
    private IMirror.MirroringState state = IMirror.MirroringState.Open;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private IBuffer buffer = null;
    private int readerNeeded = 0;
    private boolean doDispose = false;
    private PartialRequestEntry[] partials = null;

    public void setInputStream(ObjectInputStream ois) {
        this.in = ois;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    public void handle() throws GRS2ProxyMirrorInvalidOperationException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Invalid mirroring state");
        }
        if (this.socket == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No socket defined");
        }
        if (this.key == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No key defined");
        }
        if (this.getState() != Thread.State.NEW) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring already in progress");
        }
        this.setDaemon(true);
        this.setName("writer mirror (" + this.key + ")");
        this.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean purge) {
        if (this.state == IMirror.MirroringState.Purged) {
            return;
        }
        this.state = purge ? IMirror.MirroringState.Purged : IMirror.MirroringState.Close;
        if (purge) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.buffer != null) {
                    this.buffer.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean pollPartial(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorInvalidOperationException {
        throw new GRS2ProxyMirrorInvalidOperationException("Operation not supported in writer mirror");
    }

    @Override
    public long requestPartial(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorInvalidOperationException {
        throw new GRS2ProxyMirrorInvalidOperationException("Operation not supported in writer mirror");
    }

    public void writerAcceptRequests() throws Exception {
        logger.log(Level.FINEST, "HTTPWriterMirror : parseRequest....");
        this.parseRequest();
        logger.log(Level.FINEST, "HTTPWriterMirror : parseRequest....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : retrieveEvents....");
        this.retrieveEvents();
        logger.log(Level.FINEST, "HTTPWriterMirror : retrieveEvents....OK");
    }

    private boolean writerResponse() throws Exception {
        logger.log(Level.FINEST, "HTTPWriterMirror : flushPartialRequests....");
        this.flushPartialRequests();
        logger.log(Level.FINEST, "HTTPWriterMirror : flushPartialRequests....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushForwardBuffer....");
        this.flushForwardBuffer();
        logger.log(Level.FINEST, "HTTPWriterMirror : flushForwardBuffer....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushEvents....");
        this.flushEvents();
        logger.log(Level.FINEST, "HTTPWriterMirror : flushEvents....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushStatus....");
        boolean breakLoop = this.flushStatus();
        logger.log(Level.FINEST, "HTTPWriterMirror : flushStatus....OK");
        this.out.flush();
        return breakLoop;
    }

    private boolean flushStatus() throws Exception {
        Integer value = null;
        value = this.state == IMirror.MirroringState.Close ? Integer.valueOf(2) : (this.buffer.getStatus() == IBuffer.Status.Close && this.buffer.availableRecords() == 0 ? Integer.valueOf(1) : Integer.valueOf(0));
        this.out.writeInt(value);
        return value == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int cnt = 0;
        try {
            this.buffer = GRSRegistry.Registry.getBuffer(this.key);
            if (this.buffer == null && (this.state == IMirror.MirroringState.Close || this.state == IMirror.MirroringState.Purged)) {
                throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is already closed. Cannot initialize the protocol");
            }
            if (this.buffer == null && this.state == IMirror.MirroringState.Open) {
                throw new GRS2ProxyMirrorInvalidOperationException("No registry entry found for key " + this.key);
            }
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            try {
                this.flushBufferConfig();
            }
            catch (Exception ex) {
                throw new GRS2ProxyMirrorProtocolErrorException("Could not complete buffer configuration mirroring", ex);
            }
            while (this.state != IMirror.MirroringState.Purged) {
                if (this.state == IMirror.MirroringState.Close) {
                    break;
                }
                try {
                    this.writerAcceptRequests();
                }
                catch (Exception ex) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Could not parse input request", ex);
                }
                if (this.doDispose) {
                    logger.log(Level.FINEST, "Writer mirror received dispose request");
                    break;
                }
                if (this.state == IMirror.MirroringState.Purged) {
                    break;
                }
                if (this.writerResponse()) {
                    break;
                }
                if (++cnt % 100 != 0) continue;
                this.out.reset();
                if (this.in.markSupported()) {
                    this.in.reset();
                }
                cnt = 0;
            }
        }
        catch (Exception ex) {
            if (this.state == IMirror.MirroringState.Open && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Unrecoverable error during mirroring process", ex);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unrecoverable error during mirroring process", ex);
            }
        }
        finally {
            this.dispose(true);
        }
    }

    private void flushBufferConfig() throws IOException, GRS2Exception {
        BufferConfig bufferConfig = new BufferConfig();
        bufferConfig.bufferClassName = this.buffer.getClass().getName();
        bufferConfig.capacity = this.buffer.getCapacity();
        bufferConfig.concurrentPartialTimeout = this.buffer.getConcurrentPartialCapacity();
        bufferConfig.inactivityTimeout = this.buffer.getInactivityTimeout();
        bufferConfig.inactivityTimeoutUnit = this.buffer.getInactivityTimeUnit();
        bufferConfig.transportDirective = this.buffer.getTransportDirective();
        bufferConfig.recordDefinitions = new ArrayList<RecordDefinition>(Arrays.asList(this.buffer.getRecordDefinitions()));
        CompressedObjectStream.writeObject(bufferConfig, this.out);
        this.out.flush();
    }

    private void parseRequest() throws IOException, ClassNotFoundException {
        Request request = (Request)CompressedObjectStream.readObject(this.in);
        this.doDispose = request.doDispose;
        this.readerNeeded = request.needed;
        boolean simulateActivity = request.simulateActivity;
        if (simulateActivity) {
            this.buffer.markSimulateActivity();
        }
        if (request.entries != null) {
            int len = request.entries.size();
            this.partials = new PartialRequestEntry[len];
            int i = 0;
            Iterator<PartialRequestEntry> i$ = request.entries.iterator();
            while (i$.hasNext()) {
                PartialRequestEntry pre;
                this.partials[i] = pre = i$.next();
                ++i;
            }
        }
    }

    private void retrieveEvents() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2RecordSerializationException, GRS2BufferException {
        ArrayList events = (ArrayList)CompressedObjectStream.readObject(this.in);
        for (BufferEvent event : events) {
            this.buffer.emit(event);
        }
    }

    private void flushEvents() throws IOException, GRS2BufferException, GRS2RecordSerializationException {
        BufferEvent event;
        ArrayList<BufferEvent> events = new ArrayList<BufferEvent>();
        while ((event = this.buffer.receive(BufferEvent.EventSource.Writer)) != null) {
            events.add(event);
        }
        CompressedObjectStream.writeObject(events, this.out);
    }

    private void flushPartialRequests() throws GRS2Exception, IOException {
        int num = 0;
        ArrayList<PartialRequest> partialRequests = new ArrayList<PartialRequest>(this.partials.length);
        for (PartialRequestEntry entry : this.partials) {
            Record rec = this.buffer.locate(entry.getRecordIndex());
            if (rec == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid record index provided");
            }
            Field[] fields = rec.getFields();
            if (fields == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("No fields to marshal");
            }
            if (entry.getFieldIndex() < 0 || entry.getFieldIndex() >= fields.length) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid field index provided");
            }
            Field f = fields[entry.getFieldIndex()];
            PartialRequest pr = new PartialRequest();
            pr.partRecordIndex = entry.getRecordIndex();
            pr.fieldIndex = entry.getFieldIndex();
            pr.field = f;
            pr.override = entry.getOverride();
            ++num;
            partialRequests.add(pr);
        }
        CompressedObjectStream.writeObject(partialRequests, this.out);
        for (PartialRequest pr : partialRequests) {
            FileField ff = (FileField)pr.field;
            ff.extendWriteObject(this.out, pr.override);
        }
    }

    private void flushForwardBuffer() throws GRS2Exception, IOException {
        long available = this.buffer.availableRecords();
        long mirrorBuffer = this.buffer.getMirrorBuffer();
        long toMirror = this.readerNeeded;
        if (toMirror > available) {
            toMirror = available;
        }
        if (toMirror > mirrorBuffer) {
            toMirror = mirrorBuffer;
        }
        ArrayList<Record> records = new ArrayList<Record>((int)toMirror);
        int i = 0;
        while ((long)i < toMirror) {
            Record rec = this.buffer.get();
            if (rec == null) {
                if (!logger.isLoggable(Level.WARNING)) break;
                logger.log(Level.WARNING, "Record not available although declared as available");
                break;
            }
            records.add(rec);
            ++i;
        }
        this.out.writeObject(records);
    }
}

