/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer.multiplex;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreEntry;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreAccessException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.IDemultiplex;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class FifoDemultiplex
implements IDemultiplex {
    private ArrayList<BufferStoreEntry> entries = null;
    private ArrayList<RecordDefinition[]> definitionsList = null;
    private RecordWriter<Record> writer = null;
    private IBufferStore store = null;
    private Object modificationNotify = null;
    private long sendEvents = 0L;

    @Override
    public void setModificationNotify(Object notify) {
        this.modificationNotify = notify;
    }

    @Override
    public void setEntries(ArrayList<BufferStoreEntry> entries) {
        this.entries = entries;
    }

    @Override
    public void setDefinitionsList(ArrayList<RecordDefinition[]> definitionsList) {
        this.definitionsList = definitionsList;
    }

    @Override
    public void setWriter(RecordWriter<Record> writer) {
        this.writer = writer;
    }

    @Override
    public void setBufferStore(IBufferStore store) {
        this.store = store;
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void demultiplex() throws GRS2BufferStoreException {
        try {
            this.store.markActivity();
            for (int i = 0; i < this.entries.size() && this.writer.getStatus() == IBuffer.Status.Open; ++i) {
                long timeout = this.entries.get(i).getReaderTimeout();
                TimeUnit unit = this.entries.get(i).getReaderTimeoutTimeUnit();
                long recordCount = 0L;
                while (true) {
                    this.store.markActivity();
                    for (long se = this.sendEvents; se < this.entries.get(i).getEventManager().getEventCount(); ++se) {
                        BufferEvent event = this.entries.get(i).getEventManager().retrieveByIndex(se);
                        ++this.sendEvents;
                        this.writer.emit(event);
                    }
                    if (recordCount == this.entries.get(i).getRecordManager().getRecordCount() && this.entries.get(i).getStatus() == BufferStoreEntry.EntryStatus.Close) break;
                    Record record = this.entries.get(i).getRecordManager().retrieveByIndex(recordCount, true);
                    if (record == null) {
                        Object object = this.modificationNotify;
                        synchronized (object) {
                            try {
                                this.modificationNotify.wait(unit.toMillis(timeout));
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    int defCount = 0;
                    for (int d = 0; d < i; ++d) {
                        defCount += this.definitionsList.get(d).length;
                    }
                    record.setDefinitionIndex(defCount + record.getDefinitionIndex());
                    if (!this.writer.put(record, timeout, unit)) break;
                    ++recordCount;
                }
                this.store.markActivity();
            }
            this.store.markActivity();
            if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                this.writer.close();
            }
        }
        catch (GRS2Exception ex) {
            throw new GRS2BufferStoreAccessException("Could not complete multiplexing operation", ex);
        }
    }
}

