/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.lru;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.commons.infra.nodeselection.lru.TimestampComparator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LRUNodeSelector
implements NodeSelector {
    private static Map<String, Long> timingInfo = new HashMap<String, Long>();

    private HostingNode selectNode(List<HostingNode> candidates, boolean markSelected) {
        if (candidates.isEmpty()) {
            return null;
        }
        HostingNode LRUNode = null;
        Long minTimestamp = Long.MAX_VALUE;
        for (HostingNode candidate : candidates) {
            if (timingInfo.get(candidate.getId()) == null) {
                LRUNode = candidate;
                break;
            }
            Long candidateTimestamp = timingInfo.get(candidate.getId());
            if (candidateTimestamp >= minTimestamp) continue;
            minTimestamp = candidateTimestamp;
            LRUNode = candidate;
        }
        if (markSelected) {
            timingInfo.put(LRUNode.getId(), Calendar.getInstance().getTimeInMillis());
        }
        return LRUNode;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) {
        return this.selectNode(candidates, true);
    }

    @Override
    public List<HostingNodeInfo> assessNodes(List<HostingNode> candidates) {
        HostingNode selected = this.selectNode(candidates, false);
        ArrayList<HostingNodeInfo> hns = new ArrayList<HostingNodeInfo>();
        TreeMap<String, Long> sortedTimingInfo = new TreeMap<String, Long>(new TimestampComparator(timingInfo));
        sortedTimingInfo.putAll(timingInfo);
        int i = 0;
        HashSet assessedNodes = new HashSet();
        boolean foundUnselected = false;
        for (HostingNode hn : candidates) {
            if (timingInfo.containsKey(hn.getId())) continue;
            hns.add(new HostingNodeInfo(hn, Float.valueOf(1.0f)));
            foundUnselected = true;
        }
        if (foundUnselected) {
            ++i;
        }
        for (String hnId : sortedTimingInfo.keySet()) {
            for (HostingNode hn : candidates) {
                if (!hn.getId().equals(hnId)) continue;
                hns.add(new HostingNodeInfo(hn, Float.valueOf(1.0f - (float)i * (1.0f / (float)candidates.size()))));
                break;
            }
            ++i;
        }
        return hns;
    }

    @Override
    public void markSelected(HostingNode node) {
        timingInfo.put(node.getId(), Calendar.getInstance().getTimeInMillis());
    }

    public static void main(String[] args) {
    }
}

