/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.collocationpolicy;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import java.util.HashMap;
import java.util.Map;

public class CollocationRegistry {
    private Map<String, HostingNode> nodes = new HashMap<String, HostingNode>();
    private Map<String, Float> collocationScore = new HashMap<String, Float>();

    public void markSelected(HostingNode node) {
        this.nodes.put(node.getId(), node);
        if (!this.collocationScore.containsKey(node.getId())) {
            this.collocationScore.put(node.getId(), Float.valueOf(0.0f));
        }
    }

    public boolean isSelected(HostingNode node) {
        return this.nodes.containsKey(node.getId());
    }

    public float getCollocationScore(HostingNode node) throws Exception {
        if (!this.isSelected(node)) {
            throw new Exception("Node is not marked as selected");
        }
        return this.collocationScore.get(node.getId()).floatValue();
    }

    public void addToCollocationScore(HostingNode node, float value) throws Exception {
        if (!this.isSelected(node)) {
            throw new Exception("Node is not marked as selected");
        }
        this.collocationScore.put(node.getId(), Float.valueOf(this.collocationScore.get(node.getId()).floatValue() + value));
    }
}

