/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtils {
    public static void Serialize(String FileName, String XML) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(XML)));
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer tr = tf.newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        tr.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(new File(FileName))));
    }

    public static String Serialize(Node node, boolean omitDeclaration) throws Exception {
        if (node == null) {
            throw new Exception("Cannot serialize null element");
        }
        StringWriter writer = null;
        writer = new StringWriter();
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("omit-xml-declaration", omitDeclaration ? "yes" : "no");
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        tr.transform(new DOMSource(node), new StreamResult(writer));
        writer.flush();
        return writer.toString();
    }

    public static String Serialize(Node node) throws Exception {
        return XMLUtils.Serialize(node, false);
    }

    public static Document Deserialize(String XML) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(XML)));
        return doc;
    }

    public static Document Deserialize(File XML) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new FileReader(XML)));
        return doc;
    }

    public static Boolean AttributeExists(Element node, String attributeName) throws Exception {
        String val = node.getAttribute(attributeName);
        if (val.trim().length() == 0) {
            return false;
        }
        return true;
    }

    public static String GetAttribute(Element node, String attributeName) throws Exception {
        String val = node.getAttribute(attributeName);
        if (val.trim().length() == 0) {
            throw new Exception("Specified attribute not present");
        }
        return val;
    }

    public static String[] GetAttributes(Element node, boolean CollapseNamespase) throws Exception {
        NamedNodeMap map = node.getAttributes();
        String[] attrs = new String[map.getLength()];
        for (int i = 0; i < map.getLength(); ++i) {
            attrs[i] = CollapseNamespase ? map.item(i).getLocalName() : map.item(i).getNodeName();
        }
        return attrs;
    }

    public static String SerializeChild(Element parent) throws Exception {
        NodeList childer = parent.getChildNodes();
        for (int i = 0; i < childer.getLength(); ++i) {
            if (!(childer.item(i) instanceof Element)) continue;
            return XMLUtils.Serialize(childer.item(i), true);
        }
        return null;
    }

    public static Element GetChildElementWithName(Node Parent, String name) throws Exception {
        if (Parent == null) {
            return null;
        }
        NodeList children = Parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !((Element)children.item(i)).getNodeName().equals(name)) continue;
            return (Element)children.item(i);
        }
        return null;
    }

    public static Element GetChildElementWithNameAndNamespace(Node Parent, String name, String ns) throws Exception {
        if (Parent == null) {
            return null;
        }
        NodeList children = Parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !((Element)children.item(i)).getLocalName().equals(name) || !((Element)children.item(i)).getNamespaceURI().equals(ns)) continue;
            return (Element)children.item(i);
        }
        return null;
    }

    public static List<Element> GetChildElementsWithName(Node Parent, String name) throws Exception {
        ArrayList<Element> elems = new ArrayList<Element>();
        if (Parent == null) {
            return elems;
        }
        NodeList children = Parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !((Element)children.item(i)).getNodeName().equals(name)) continue;
            elems.add((Element)children.item(i));
        }
        return elems;
    }

    public static List<Element> GetChildElementsWithNameAndNamespace(Node Parent, String name, String ns) throws Exception {
        ArrayList<Element> elems = new ArrayList<Element>();
        if (Parent == null) {
            return elems;
        }
        NodeList children = Parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !((Element)children.item(i)).getLocalName().equals(name) || !((Element)children.item(i)).getNamespaceURI().equals(ns)) continue;
            elems.add((Element)children.item(i));
        }
        return elems;
    }

    public static String GetChildTextOrFirstNonEmptyChildElementAsText(Node Parent) throws Exception {
        String ret = XMLUtils.GetChildText(Parent);
        if (ret != null) {
            return ret;
        }
        NodeList lst = Parent.getChildNodes();
        for (int i = 0; i < lst.getLength(); ++i) {
            if (lst == null || !(lst instanceof Element)) continue;
            return XMLUtils.Serialize(lst.item(i));
        }
        return null;
    }

    public static String GetChildCDataText(Node Parent) throws Exception {
        if (Parent == null) {
            return null;
        }
        NodeList children = Parent.getChildNodes();
        if (children == null) {
            return null;
        }
        String ret = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof CDATASection)) continue;
            ret = ((CDATASection)children.item(i)).getNodeValue();
            break;
        }
        return ret;
    }

    public static String GetChildText(Node Parent) throws Exception {
        if (Parent == null) {
            return null;
        }
        NodeList children = Parent.getChildNodes();
        if (children == null) {
            return null;
        }
        String ret = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Text)) continue;
            ret = ((Text)children.item(i)).getWholeText();
            break;
        }
        return ret;
    }

    public static Object Query(Document doc, String query, QName type) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return xpath.evaluate(query, doc, type);
    }

    public static String Transform(String Source2, String xslt) throws Exception {
        StringWriter writer = null;
        writer = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(new StringReader(xslt)));
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new StreamSource(new StringReader(Source2)), new StreamResult(writer));
        writer.flush();
        return writer.toString();
    }

    public static String DoReplaceSpecialCharachters(String XML) {
        if (XML == null) {
            return null;
        }
        String tmp = XML.replaceAll("&", "&amp;");
        tmp = tmp.replaceAll("<", "&lt;");
        tmp = tmp.replaceAll(">", "&gt;");
        tmp = tmp.replaceAll("\"", "&quot;");
        tmp = tmp.replaceAll("'", "&apos;");
        return tmp;
    }

    public static String UndoReplaceSpecialCharachters(String XML) {
        if (XML == null) {
            return null;
        }
        String tmp = XML.replaceAll("&lt;", "<");
        tmp = tmp.replaceAll("&gt;", ">");
        tmp = tmp.replaceAll("&quot;", "\"");
        tmp = tmp.replaceAll("&apos;", "'");
        tmp = tmp.replaceAll("&amp;", "&");
        return tmp;
    }
}

