/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.tcp;

import gr.uoa.di.madgik.commons.channel.nozzle.INozzleConfig;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelProxy;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPServerChannelProxy;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TCPServerNozzleConfig
implements INozzleConfig {
    private IChannelProxy ChannelProxy = null;
    private boolean Broadcast = false;
    private int RestrictBroadcast = 0;

    public TCPServerNozzleConfig() {
    }

    public TCPServerNozzleConfig(boolean Broadcast, int RestrictBroadcast) {
        this.ChannelProxy = new TCPServerChannelProxy();
        this.Broadcast = Broadcast;
        this.RestrictBroadcast = RestrictBroadcast;
    }

    @Override
    public IChannelProxy GetChannelProxy() {
        if (this.ChannelProxy == null) {
            this.ChannelProxy = new TCPServerChannelProxy();
        }
        return this.ChannelProxy;
    }

    @Override
    public void SetProxy(IChannelProxy ChannelProxy) {
        this.ChannelProxy = ChannelProxy;
    }

    @Override
    public boolean GetIsBroadcast() {
        return this.Broadcast;
    }

    @Override
    public void SetIsBroadcast(boolean Broadcast) {
        this.Broadcast = Broadcast;
    }

    @Override
    public int GetRestrictBroadcast() {
        return this.RestrictBroadcast;
    }

    @Override
    public void SetRestrictBroadcast(int RestrictBroadcast) {
        this.RestrictBroadcast = RestrictBroadcast;
    }

    @Override
    public void Dispose() {
        this.ChannelProxy.Dispose();
    }

    @Override
    public INozzleConfig.ConfigType GetConfigType() {
        return INozzleConfig.ConfigType.TCP;
    }

    @Override
    public void FromXML(String XML) throws Exception {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize(XML);
        }
        catch (Exception ex) {
            throw new Exception("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws Exception {
        if (!(XMLUtils.AttributeExists((Element)XML, "type").booleanValue() && XMLUtils.AttributeExists((Element)XML, "broadcast").booleanValue() && XMLUtils.AttributeExists((Element)XML, "restrict").booleanValue())) {
            throw new Exception("Not valid serialization of element");
        }
        if (!INozzleConfig.ConfigType.valueOf(XMLUtils.GetAttribute((Element)XML, "type")).equals((Object)this.GetConfigType())) {
            throw new Exception("Not valid serialization of element");
        }
        this.Broadcast = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XML, "broadcast"));
        this.RestrictBroadcast = Integer.parseInt(XMLUtils.GetAttribute((Element)XML, "restrict"));
    }

    @Override
    public String ToXML() throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("<nozzleConfig type=\"" + this.GetConfigType().toString() + "\" broadcast=\"" + this.Broadcast + "\" restrict=\"" + this.RestrictBroadcast + "\"/>");
        return buf.toString();
    }
}

