/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.madgik.environment.notifications.model;

import gr.uoa.di.madgik.environment.notifications.Message;
import gr.uoa.di.madgik.environment.notifications.NotificationMessageListenerI;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralMessageListener
implements MessageListener {
    NotificationMessageListenerI messageListener;
    Logger logger = LoggerFactory.getLogger((String)GeneralMessageListener.class.getName());

    public void setNotificationMessageListener(NotificationMessageListenerI ml) {
        this.messageListener = ml;
    }

    public void onMessage(javax.jms.Message message) {
        if (message instanceof TextMessage) {
            TextMessage textJmsMsg = (TextMessage)message;
            gr.uoa.di.madgik.environment.notifications.TextMessage msg = new gr.uoa.di.madgik.environment.notifications.TextMessage();
            try {
                msg.setText(textJmsMsg.getText());
            }
            catch (JMSException e) {
                this.logger.error("Error while getting text from JMS message");
            }
            try {
                Enumeration propertyNames = textJmsMsg.getPropertyNames();
                while (propertyNames.hasMoreElements()) {
                    String name = (String)propertyNames.nextElement();
                    try {
                        msg.addStringProperty(name, textJmsMsg.getStringProperty(name));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                    try {
                        msg.addBooleanProperty(name, Boolean.valueOf(textJmsMsg.getBooleanProperty(name)));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                    try {
                        msg.addByteProperty(name, textJmsMsg.getByteProperty(name));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                    try {
                        msg.addDoubleProperty(name, Double.valueOf(textJmsMsg.getDoubleProperty(name)));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                    try {
                        msg.addFloatProperty(name, Float.valueOf(textJmsMsg.getFloatProperty(name)));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                    try {
                        msg.addIntProperty(name, Integer.valueOf(textJmsMsg.getIntProperty(name)));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                    try {
                        msg.addObjectProperty(name, textJmsMsg.getObjectProperty(name));
                    }
                    catch (JMSException e) {
                        this.logger.error(e.getMessage());
                    }
                }
            }
            catch (JMSException e) {
                this.logger.error("Error while getting JMS message property names.");
            }
            try {
                msg.setRedelivered(textJmsMsg.getJMSRedelivered());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            try {
                msg.setDeliveryMode(textJmsMsg.getJMSDeliveryMode());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            try {
                msg.setExpiration(textJmsMsg.getJMSExpiration());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            try {
                msg.setMessageID(textJmsMsg.getJMSMessageID());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            try {
                msg.setMessageType(textJmsMsg.getJMSType());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            try {
                msg.setPriority(textJmsMsg.getJMSPriority());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            try {
                msg.setTimestamp(textJmsMsg.getJMSTimestamp());
            }
            catch (JMSException e) {
                this.logger.error(e.getMessage());
            }
            this.messageListener.onMessage((Message)msg);
        }
    }
}

