/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IRRElement;

public abstract class RRElement
implements IRRElement {
    @Override
    public boolean exists() throws ResourceRegistryException {
        if (ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.REFRESH_AHEAD) || ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.READ_LOCAL)) {
            return this.exists(RRContext.DatastoreType.LOCAL);
        }
        if (ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.READ_THROUGH)) {
            if (this.exists(RRContext.ReadPolicy.READ_LOCAL)) {
                return true;
            }
            return this.exists(RRContext.ReadPolicy.READ_THROUGH);
        }
        throw new ResourceRegistryException("Failed to find supported read policy");
    }

    @Override
    public boolean exists(RRContext.ReadPolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isReadPolicySupported(policy)) {
            throw new ResourceRegistryException("Read policy not supported");
        }
        if (policy == RRContext.ReadPolicy.READ_LOCAL || policy == RRContext.ReadPolicy.REFRESH_AHEAD) {
            return this.exists(RRContext.DatastoreType.LOCAL);
        }
        if (policy == RRContext.ReadPolicy.READ_THROUGH) {
            if (ResourceRegistry.getContext().isDatastoreSupportedForRead(RRContext.DatastoreType.REMOTE)) {
                return this.exists(RRContext.DatastoreType.REMOTE);
            }
            ResourceRegistry.retrieveDirect(this.getClass(), this.getID());
            return this.exists(RRContext.DatastoreType.LOCAL);
        }
        throw new ResourceRegistryException("Unsupported read policy");
    }

    @Override
    public boolean load(boolean loadDetails) throws ResourceRegistryException {
        if (ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.REFRESH_AHEAD)) {
            return this.load(loadDetails, RRContext.DatastoreType.LOCAL);
        }
        if (ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.READ_THROUGH) && ResourceRegistry.isReadPolicySupported(RRContext.ReadPolicy.READ_LOCAL)) {
            if (this.load(loadDetails, RRContext.ReadPolicy.READ_LOCAL)) {
                return true;
            }
            return this.load(loadDetails, RRContext.ReadPolicy.READ_THROUGH);
        }
        throw new ResourceRegistryException("Failed to find supported read policy");
    }

    @Override
    public boolean load(boolean loadDetails, RRContext.ReadPolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isReadPolicySupported(policy)) {
            throw new ResourceRegistryException("Read policy not supported");
        }
        if (policy == RRContext.ReadPolicy.READ_LOCAL || policy == RRContext.ReadPolicy.REFRESH_AHEAD) {
            return this.load(loadDetails, RRContext.DatastoreType.LOCAL);
        }
        if (policy == RRContext.ReadPolicy.READ_THROUGH) {
            boolean result = false;
            if (ResourceRegistry.getContext().isDatastoreSupportedForRead(RRContext.DatastoreType.REMOTE)) {
                result = this.load(loadDetails, RRContext.DatastoreType.REMOTE);
                if (result) {
                    this.store(loadDetails, RRContext.DatastoreType.LOCAL);
                }
                return result;
            }
            ResourceRegistry.retrieveDirect(this.getClass(), this.getID());
            return this.load(loadDetails, RRContext.DatastoreType.LOCAL);
        }
        throw new ResourceRegistryException("Unsupported read policy");
    }

    @Override
    public void store(boolean storeDetails) throws ResourceRegistryException {
        if (ResourceRegistry.isWritePolicySupported(RRContext.WritePolicy.WRITE_BEHIND)) {
            this.store(storeDetails, RRContext.DatastoreType.LOCAL);
        } else if (ResourceRegistry.isWritePolicySupported(RRContext.WritePolicy.WRITE_THROUGH)) {
            this.store(storeDetails, RRContext.WritePolicy.WRITE_THROUGH);
        } else {
            throw new ResourceRegistryException("Failed to find supported write policy");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void store(boolean storeDetails, RRContext.WritePolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isWritePolicySupported(policy)) {
            throw new ResourceRegistryException("Write policy not supported");
        }
        if (policy == RRContext.WritePolicy.WRITE_LOCAL || policy == RRContext.WritePolicy.WRITE_BEHIND) {
            this.store(storeDetails, RRContext.DatastoreType.LOCAL);
            return;
        } else {
            if (policy != RRContext.WritePolicy.WRITE_THROUGH) throw new ResourceRegistryException("Unsupported read policy");
            if (!ResourceRegistry.getContext().isDatastoreSupportedForWrite(RRContext.DatastoreType.REMOTE)) throw new ResourceRegistryException("This element does not support storing");
            this.store(storeDetails, RRContext.DatastoreType.REMOTE);
            this.store(storeDetails, RRContext.DatastoreType.LOCAL);
        }
    }

    @Override
    public void delete(boolean deleteDetails) throws ResourceRegistryException {
        if (ResourceRegistry.isWritePolicySupported(RRContext.WritePolicy.WRITE_BEHIND)) {
            this.delete(deleteDetails, RRContext.DatastoreType.LOCAL);
        } else if (ResourceRegistry.isWritePolicySupported(RRContext.WritePolicy.WRITE_THROUGH)) {
            this.delete(deleteDetails, RRContext.WritePolicy.WRITE_THROUGH);
        }
        throw new ResourceRegistryException("Failed to find supported write policy");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(boolean deleteDetails, RRContext.WritePolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isWritePolicySupported(policy)) {
            throw new ResourceRegistryException("Write policy not supported");
        }
        if (policy == RRContext.WritePolicy.WRITE_LOCAL || policy == RRContext.WritePolicy.WRITE_BEHIND) {
            this.delete(deleteDetails, RRContext.DatastoreType.LOCAL);
            return;
        } else {
            if (policy != RRContext.WritePolicy.WRITE_THROUGH) throw new ResourceRegistryException("Unsupported write policy");
            if (!ResourceRegistry.getContext().isDatastoreSupportedForWrite(RRContext.DatastoreType.REMOTE)) throw new ResourceRegistryException("This element does not support deletion");
            this.delete(deleteDetails, RRContext.DatastoreType.REMOTE);
            this.delete(deleteDetails, RRContext.DatastoreType.LOCAL);
        }
    }
}

