/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.utils;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import org.datanucleus.api.jdo.JDOReplicationManager;

public class DatastoreHelper {
    private static Logger logger = Logger.getLogger(DatastoreHelper.class.getName());

    public static void replicate(RRContext.DatastoreType source, RRContext.DatastoreType target, Set<Class<?>> objects) throws ResourceRegistryException {
        logger.log(Level.INFO, "Number of objects types to replicate " + objects.size());
        logger.log(Level.INFO, "Objects:  " + objects);
        RRContext context = ResourceRegistry.getContext();
        JDOReplicationManager replicator = new JDOReplicationManager(context.getFactoryForRead(source), context.getFactoryForWrite(target));
        replicator.replicate(objects.toArray(new Class[0]));
    }

    public static void resolveUpdateConflicts(RRContext.DatastoreType source, RRContext.DatastoreType target, Set<Class<?>> objects) throws ResourceRegistryException {
        RRContext context = ResourceRegistry.getContext();
        PersistenceManager pmR = context.getFactoryForRead(target).getPersistenceManager();
        PersistenceManager pmW = context.getFactoryForWrite(source).getPersistenceManager();
        try {
            for (Class<?> itemType : objects) {
                HashSet<String> itemsInConflict = new HashSet<String>();
                Set<IDaoElement> sourceItems = DatastoreHelper.getItems(source, itemType, true);
                HashMap<String, IDaoElement> sourceItemIndex = new HashMap<String, IDaoElement>();
                for (IDaoElement item : sourceItems) {
                    sourceItemIndex.put(item.getID(), item);
                }
                Set<IDaoElement> targetItems = DatastoreHelper.getItems(target, itemType, true);
                for (IDaoElement targetItem : targetItems) {
                    IDaoElement iDaoElement = (IDaoElement)sourceItemIndex.get(targetItem.getID());
                    if (iDaoElement == null || targetItem.getTimestamp() <= iDaoElement.getTimestamp()) continue;
                    itemsInConflict.add(targetItem.getID());
                }
                if (itemsInConflict.size() <= 0) continue;
                ArrayList<Object> objs = new ArrayList<Object>();
                pmR.currentTransaction().begin();
                for (Object e : itemsInConflict) {
                    logger.log(Level.INFO, "Conflict: Item: " + itemType + " id: " + e.toString());
                    objs.add(pmR.detachCopy(pmR.getObjectById(itemType, (Object)((String)e))));
                }
                pmR.currentTransaction().commit();
                pmW.currentTransaction().begin();
                for (Object e : objs) {
                    pmW.makePersistent(e);
                }
                pmW.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not resolve update conflicts", e);
        }
        finally {
            if (pmR.currentTransaction().isActive()) {
                pmR.currentTransaction().rollback();
            }
            if (pmW.currentTransaction().isActive()) {
                pmW.currentTransaction().rollback();
            }
            pmR.close();
            pmW.close();
        }
    }

    public static Set<IDaoElement> getItems(RRContext.DatastoreType target, Class<?> obj) throws Exception {
        return DatastoreHelper.getItems(target, obj, false);
    }

    public static Set<IDaoElement> getItems(RRContext.DatastoreType target, Class<?> obj, boolean overridePrefetched) throws Exception {
        return DatastoreHelper.getItems(target, obj, overridePrefetched, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IDaoElement> getItems(RRContext.DatastoreType target, Class<?> obj, boolean overridePrefetched, boolean detach) throws Exception {
        IRRElement i;
        Set<IRRElement> retrieved;
        HashSet<IDaoElement> memRetrieved = new HashSet<IDaoElement>();
        if (target.equals((Object)RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isTargetInMemory(obj.getName()) && !overridePrefetched && (retrieved = InMemoryStore.getItems(obj)) != null) {
            for (IRRElement element : retrieved) {
                if (element.getItem() == null) continue;
                memRetrieved.add(element.getItem());
            }
            return memRetrieved;
        }
        if (obj.isInstance(IRRElement.class) && (i = (IRRElement)obj.newInstance()).getItem() != null) {
            obj = i.getItem().getClass();
        }
        RRContext context = ResourceRegistry.getContext();
        PersistenceManager pm = context.getManagerForRead(target);
        try {
            pm.currentTransaction().begin();
            Extent ex = pm.getExtent(obj, true);
            Iterator iter = ex.iterator();
            HashSet<IDaoElement> coll = new HashSet<IDaoElement>();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof IDaoElement)) continue;
                coll.add(detach ? (IDaoElement)pm.detachCopy((Object)((IDaoElement)o)) : (IDaoElement)o);
            }
            pm.currentTransaction().commit();
            HashSet<IDaoElement> hashSet = coll;
            return hashSet;
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(RRContext.DatastoreType target, Set<Class<?>> objects) throws ResourceRegistryException {
        for (Class<?> type : objects) {
            if (!target.equals((Object)RRContext.DatastoreType.LOCAL) || !ResourceRegistry.getContext().isTargetInMemory(type.getName())) continue;
            InMemoryStore.setItems(type, null);
        }
        RRContext context = ResourceRegistry.getContext();
        PersistenceManager pm = context.getManagerForWrite(target);
        try {
            pm.currentTransaction().begin();
            for (Class<?> cls : objects) {
                Extent ex = pm.getExtent(cls, true);
                Iterator iter = ex.iterator();
                HashSet<IDaoElement> coll = new HashSet<IDaoElement>();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof IDaoElement)) continue;
                    coll.add((IDaoElement)obj);
                }
                logger.log(Level.FINE, "Number of objects of type " + cls.getName() + " to delete is " + coll.size());
                pm.deletePersistentAll(coll);
            }
            pm.currentTransaction().commit();
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IDaoElement> retrieveAll(RRContext.DatastoreType target, Class<?> object) throws ResourceRegistryException {
        HashSet<IDaoElement> coll = new HashSet<IDaoElement>();
        RRContext context = ResourceRegistry.getContext();
        PersistenceManager pm = context.getManagerForRead(target);
        try {
            pm.currentTransaction().begin();
            Extent ex = pm.getExtent(object, true);
            for (Object o : ex) {
                if (!(o instanceof IDaoElement)) continue;
                coll.add((IDaoElement)pm.detachCopy((Object)((IDaoElement)o)));
            }
            logger.log(Level.FINE, "Number of objects of type " + object.getName() + " retrieved is " + coll.size());
            pm.currentTransaction().commit();
            HashSet<IDaoElement> hashSet = coll;
            return hashSet;
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeItems(Set<IDaoElement> items, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        PersistenceManager pm = ResourceRegistry.getContext().getManagerForWrite(persistencyType);
        try {
            pm.currentTransaction().begin();
            for (IDaoElement item : items) {
                pm.makePersistent((Object)item);
            }
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "storeItems error occured", e);
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    public static void bufferItems(Set<IDaoElement> items) throws ResourceRegistryException {
        DatastoreHelper.storeItems(items, RRContext.DatastoreType.LOCALBUFFER);
    }

    public static void persistItems(Set<IDaoElement> items) throws ResourceRegistryException {
        DatastoreHelper.storeItems(items, RRContext.DatastoreType.LOCAL);
    }
}

