/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class Plugin {
    protected Type type;
    protected long period = -1L;
    protected TimeUnit periodUnit = null;
    protected Set<ProcessedItemType> processedItems = new HashSet<ProcessedItemType>();
    protected Map<ProcessedItemType, Set<? extends IRRElement>> items = new HashMap<ProcessedItemType, Set<? extends IRRElement>>();
    protected Map<ProcessedItemType, Set<? extends IDaoElement>> itemDaos = new HashMap<ProcessedItemType, Set<? extends IDaoElement>>();

    public void readConfiguration(String prefix, Properties properties) throws ResourceRegistryException {
        if (properties == null) {
            return;
        }
        String propPeriod = properties.getProperty(prefix + ".period");
        if (propPeriod != null) {
            if (this.type != Type.PERIODIC) {
                throw new ResourceRegistryException("Attempt to set period to non-periodic plugin");
            }
            String propPeriodUnit = properties.getProperty(prefix + ".periodUnit");
            this.period = Long.parseLong(propPeriod.trim());
            if (this.period <= 0L) {
                throw new IllegalArgumentException("Non-positive value for period not allowed");
            }
            this.periodUnit = TimeUnit.valueOf(propPeriodUnit.trim());
        }
    }

    public Type getType() {
        return this.type;
    }

    public Set<ProcessedItemType> getProcessedItems() {
        return new HashSet<ProcessedItemType>(this.processedItems);
    }

    private void clearItems() {
        this.items.clear();
        this.itemDaos.clear();
    }

    public void addProcessedItems(ProcessedItemType type, Set<? extends IRRElement> items) {
        this.items.put(type, items);
    }

    public void addProcessedItemDaos(ProcessedItemType type, Set<? extends IDaoElement> items) {
        this.itemDaos.put(type, items);
    }

    public long getPeriod() {
        if (this.type != Type.PERIODIC) {
            throw new UnsupportedOperationException();
        }
        return this.period;
    }

    public TimeUnit getPeriodUnit() {
        if (this.type != Type.PERIODIC) {
            throw new UnsupportedOperationException();
        }
        return this.periodUnit;
    }

    public abstract void setup() throws ResourceRegistryException;

    protected abstract void execute(Set<Class<?>> var1) throws ResourceRegistryException;

    public void executePlugin(Set<Class<?>> targets) throws ResourceRegistryException {
        this.execute(targets);
        this.clearItems();
    }

    public static enum Type {
        PRE_RETRIEVE,
        POST_RETRIEVE,
        PRE_UPDATE,
        POST_UPDATE,
        PERIODIC,
        ONE_OFF;

    }

    public static class ProcessedItemType {
        public final Class<?> itemType;
        public final RRContext.DatastoreType datastoreType;

        public ProcessedItemType(Class<?> itemType, RRContext.DatastoreType datastoreType) {
            this.itemType = itemType;
            this.datastoreType = datastoreType;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProcessedItemType)) {
                return false;
            }
            if (!this.itemType.getName().equals(((ProcessedItemType)other).itemType.getName())) {
                return false;
            }
            return this.datastoreType == ((ProcessedItemType)other).datastoreType;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.itemType == null ? 0 : this.itemType.getName().hashCode());
            hash = 31 * hash + (this.datastoreType == null ? 0 : this.datastoreType.toString().hashCode());
            return hash;
        }
    }
}

