/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.configuration.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.execution.rr.configuration.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProviderWebServiceImpl
implements ConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationProviderWebServiceImpl.class);
    private Properties properties = null;

    private synchronized Properties getPropertyFile() throws Exception {
        if (this.properties != null) {
            return this.properties;
        }
        String filename = "deploy.properties";
        this.properties = new Properties();
        try (InputStream is = Resources.getResource((String)filename).openStream();){
            this.properties.load(is);
        }
        catch (Exception e) {
            throw new Exception("could not load property file  : " + filename);
        }
        return this.properties;
    }

    public List<String> getGHNContextStartScopes() {
        try {
            Properties prop = this.getPropertyFile();
            String scopeProperty = prop.getProperty("scope").trim();
            ArrayList scopes = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)scopeProperty));
            logger.info("scopes in property file : " + scopes);
            return scopes;
        }
        catch (Exception e) {
            logger.error("error while getting scope from property file ", (Throwable)e);
            return null;
        }
    }

    public List<String> getGHNContextScopes() {
        try {
            Properties prop = this.getPropertyFile();
            String scopeProperty = prop.getProperty("scope").trim();
            ArrayList scopes = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)scopeProperty));
            return scopes;
        }
        catch (Exception e) {
            logger.error("error while getting scope from property file ", (Throwable)e);
            return null;
        }
    }

    public boolean isClientMode() {
        try {
            Properties prop = this.getPropertyFile();
            boolean isClientMode = Boolean.valueOf(prop.getProperty("clientMode", "true"));
            logger.info("isClientMode in property file (true for default) : " + isClientMode);
            return isClientMode;
        }
        catch (Exception e) {
            logger.error("error while getting clientMode from property file ", (Throwable)e);
            return true;
        }
    }
}

